/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySalaryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QrySalaryPayImpl.class);

    public int getBatchSize() {
        return 100;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getTransforQueryRequestBody(paymentInfos));
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        return "<?xml version=\"1.0\" encoding=\"" + RequestContextUtils.getCharset() + "\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        Element ebenk = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element head = ebenk.getChild("head");
        if (!"000000".equals(head.getChildTextTrim("retCode"))) {
            String errorMsg = head.getChildText("retMessage");
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ebenk.getChild("body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"list");
        List Elements = list.getChildren("row");
        paymentInfos = this.preBatchSameItemCheck(bankPayRequest);
        for (Element element : Elements) {
            String recAccount = JDomUtils.getChildTextTrim((Element)element, (String)"recAccount");
            String recAccountName = JDomUtils.getChildTextTrim((Element)element, (String)"recAccountName");
            String payAmount = JDomUtils.getChildTextTrim((Element)element, (String)"payAmount");
            BigDecimal biga = new BigDecimal(payAmount);
            String key = recAccount + "_" + recAccountName + "_" + BigDecimalHelper.plain2((BigDecimal)biga);
            PaymentInfo info = this.selectPaymentInfo(paymentInfos, key);
            if (null == info) {
                logger.info("info\u4e3a\u7a7a\uff0ckey\uff1a" + key);
                continue;
            }
            String orderState = JDomUtils.getChildTextTrim((Element)element, (String)"orderState");
            String errorMessage = JDomUtils.getChildTextTrim((Element)element, (String)"errorMessage");
            this.handlePayStatus(info, orderState, errorMessage);
        }
        this.processingBankItemDataHandler(Elements);
        PayStatusMatchUtil.backBatchSameItemHandler((List)bankPayRequest.getPaymentInfos(), (boolean)false, (boolean)false);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String orderState = JDomUtils.getChildTextTrim((Element)element, (String)"orderState");
                    String errorMessage = JDomUtils.getChildTextTrim((Element)element, (String)"errorMessage");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, orderState, errorMessage);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String orderState, String errorMessage) {
        if ("90".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)orderState, (String)"");
        } else if ("99".equalsIgnoreCase(orderState) || "71".equalsIgnoreCase(orderState) || "92".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)orderState, (String)errorMessage);
        } else if ("50".equalsIgnoreCase(orderState) || "51".equalsIgnoreCase(orderState) || "20".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)orderState, (String)errorMessage);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)orderState, (String)errorMessage);
        }
        return tempInfo;
    }

    private String getBankDataKey(Element element) {
        String recAccount = JDomUtils.getChildTextTrim((Element)element, (String)"recAccount");
        String recAccountName = JDomUtils.getChildTextTrim((Element)element, (String)"recAccountName");
        String payAmount = JDomUtils.getChildTextTrim((Element)element, (String)"payAmount");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(recAccount).append(recAccountName).append(new BigDecimal(payAmount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE070711";
    }

    public String getBizDesc() {
        return null;
    }

    private Element getTransforQueryRequestBody(PaymentInfo[] paymentInfos) {
        PaymentInfo info = paymentInfos[0];
        Element body = new Element("body");
        String batchNo = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"batchNo");
        if (StringUtils.isEmpty((String)batchNo)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6d41\u6c34\u53f7batchNo\u4e3a\u7a7a\u3002", (String)"QrySalaryPayImpl_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)batchNo);
        JDomUtils.addChild((Element)body, (String)"turnPageBeginPos", (String)"1");
        JDomUtils.addChild((Element)body, (String)"turnPageShowNum", (String)"100");
        return body;
    }

    private PaymentInfo selectPaymentInfo(List<PaymentInfo> paymentInfos, String key) {
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = paymentInfos.get(i);
            if (!key.equals(paymentInfo.getIncomeAccNo() + "_" + paymentInfo.getIncomeAccName() + "_" + paymentInfo.getAmount())) continue;
            return paymentInfo;
        }
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }
}

