/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boimc.dc.service.payment;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boimc.dc.service.ResponseChecker;
import kd.ebg.aqap.banks.boimc.dc.service.payment.BankInnerQueryPayImpl;
import kd.ebg.aqap.banks.boimc.dc.service.payment.PaymentChecker;
import kd.ebg.aqap.banks.boimc.dc.service.utils.DateFormatter;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BankInnerPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankInnerPayImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BankInnerQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        new PaymentChecker().check4Payment(paymentInfos);
        Element message = new Element("Message");
        Element head = new Element("Head");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EBankInnerTransfer");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateFormatter.format2DateTime(new Date()));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)body);
        Element list = new Element("List");
        JDomUtils.addChild((Element)body, (Element)list);
        Element map = new Element("Map");
        JDomUtils.addChild((Element)list, (Element)map);
        String payerAccNo = ((PaymentInfo)paymentInfos.get(0)).getAccNo();
        String payeeAccNo = ((PaymentInfo)paymentInfos.get(0)).getIncomeAccNo();
        String payeeAccName = ((PaymentInfo)paymentInfos.get(0)).getIncomeAccName();
        String payAmount = ((PaymentInfo)paymentInfos.get(0)).getAmount().toString();
        String remark = ((PaymentInfo)paymentInfos.get(0)).getExplanation();
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)payerAccNo);
        JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)payeeAccNo);
        JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)payeeAccName);
        JDomUtils.addChild((Element)map, (String)"Amount", (String)payAmount);
        if (((PaymentInfo)paymentInfos.get(0)).is2Individual()) {
            JDomUtils.addChild((Element)map, (String)"TransferObject", (String)"1");
        } else {
            JDomUtils.addChild((Element)map, (String)"TransferObject", (String)"0");
        }
        this.logger.info(!((PaymentInfo)paymentInfos.get(0)).is2Individual() ? "\u5bf9\u516c\u4ed8\u6b3e" : "\u5bf9\u79c1\u4ed8\u6b3e");
        System.out.println("is isisisi    " + ((PaymentInfo)paymentInfos.get(0)).is2Individual());
        JDomUtils.addChild((Element)map, (String)"Remark", (String)remark);
        JDomUtils.addChild((Element)map, (String)"EASId", (String)("KD" + ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()));
        PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(0)));
        this.logger.info("[\u4ed8\u6b3e\u8d26\u53f7\uff1a" + payerAccNo);
        this.logger.info("\u6536\u6b3e\u8d26\u53f7\uff1a" + payeeAccNo);
        this.logger.info("\u6536\u6b3e\u8d26\u6237\u540d\uff1a" + payeeAccName);
        this.logger.info("\u4ea4\u6613\u91d1\u989d\uff1a" + payAmount);
        this.logger.info("\u5907\u6ce8\uff1a" + remark + "]");
        return JDomUtils.root2String((Element)message, (String)"GBK");
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String resp) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)resp, (String)"GBK");
        ResponseChecker.checkResponse(paymentInfos, root, ResManager.loadKDString((String)"\u8f6c\u5e10\u4ed8\u6b3e\u4e1a\u52a1", (String)"BankInnerPayImpl_0", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElementNotNull((Element)body, (String)"List");
        List maps = list.getChildren();
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = JDomUtils.getChildTextNotNull((Element)map, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"BankInnerPayImpl_1", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String returnMsg = JDomUtils.getChildText((Element)map, (String)"ReturnMsg");
            this.logger.info("\u8f6c\u5e10\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + returnCode + ", \u8f6c\u5e10\u8fd4\u56de\u4fe1\u606f\uff1a" + returnMsg);
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BankInnerPayImpl_2", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("eweb/B2EBankInnerTransfer.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"PASSWORD") + "&SIGDATA=1");
        factory.setHttpHeader("Content-Type", "charset=GBK");
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBankInnerTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u540c\u884c\u4ed8\u6b3e", (String)"BankInnerPayImpl_3", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

