/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.financing.FinancingInfo;

public class PackerUtils {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static Map<String, String> staMap = new HashMap<String, String>(10);

    public static String convertYuan2CentStr(BigDecimal yuan) {
        yuan = yuan.multiply(ONE_HUNDRED);
        yuan = yuan.setScale(0);
        return yuan.toString();
    }

    public static String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }

    public static boolean isBelowZero(BigDecimal amount) {
        boolean flag = true;
        if (null != amount && amount.compareTo(ZERO) > 0) {
            flag = false;
        }
        return flag;
    }

    public static Long getTotalAmountLong(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        bigDecimal = bigDecimal.multiply(ONE_HUNDRED);
        return bigDecimal.longValue();
    }

    public static Long getAmountLong(PaymentInfo paymentInfos) {
        BigDecimal bigDecimal = paymentInfos.getAmount();
        bigDecimal = bigDecimal.multiply(ONE_HUNDRED);
        return bigDecimal.longValue();
    }

    public static BigDecimal getAmount(PaymentInfo paymentInfos) {
        BigDecimal bigDecimal = paymentInfos.getAmount();
        return bigDecimal.multiply(ONE_HUNDRED);
    }

    public static BigDecimal getAmount(FinancingInfo financingInfo) {
        BigDecimal bigDecimal = new BigDecimal(financingInfo.getAmount());
        return bigDecimal.multiply(ONE_HUNDRED);
    }

    static {
        staMap.put("0", ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u7b54\u590d\u3002", (String)"PackerUtils_0", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("1", ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f\u7b49\u5f85\u94f6\u884c\u7b54\u590d\u3002", (String)"PackerUtils_1", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("2", ResManager.loadKDString((String)"\u7b49\u5f85\u6388\u6743", (String)"PackerUtils_2", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("3", ResManager.loadKDString((String)"\u7b49\u5f85\u4e8c\u6b21\u6388\u6743", (String)"PackerUtils_3", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("4", ResManager.loadKDString((String)"\u7b49\u5f85\u94f6\u884c\u7b54\u590d", (String)"PackerUtils_4", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("5", ResManager.loadKDString((String)"\u8d85\u671f\u4f5c\u5e9f", (String)"PackerUtils_5", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("6", ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"PackerUtils_6", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("7", ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"PackerUtils_7", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("8", ResManager.loadKDString((String)"\u6307\u4ee4\u88ab\u6388\u6743\u62d2\u7edd\u3002", (String)"PackerUtils_8", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
        staMap.put("9", ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"PackerUtils_9", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]));
    }
}

