/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.opa.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.spdb.opa.service.Check;
import kd.ebg.aqap.banks.spdb.opa.service.Packer;
import kd.ebg.aqap.banks.spdb.opa.service.ParserRsp;
import kd.ebg.aqap.banks.spdb.opa.service.Signature;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse commonDetail(BankDetailRequest request) {
        ArrayList result = new ArrayList(1);
        this.setCurrentPage("1");
        boolean isLastPage = false;
        this.setLastPage(false);
        while (!isLastPage) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            if (Objects.nonNull(detailResponse) && Objects.nonNull(detailResponse.getDetails())) {
                if (CollectionUtils.isEmpty((Collection)detailResponse.getDetails())) break;
                result.addAll(detailResponse.getDetails());
            }
            int nextTag = Integer.parseInt(this.getCurrentPage());
            this.setCurrentPage(nextTag += 20);
            isLastPage = this.isLastPage();
        }
        return new EBBankDetailResponse(result);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.commonDetail(request);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.commonDetail(request);
    }

    public String pack(BankDetailRequest request) {
        return this.packDetail(request, this.getCurrentPage());
    }

    private String packDetail(BankDetailRequest request, String pageTag) {
        Element body = new Element("body");
        String accNo = request.getAcnt().getAccNo();
        String beginDate = request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDate = request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        JDomUtils.addChild((Element)body, (String)"unfSocCrdtNo", (String)RequestContextUtils.getBankParameterValue((String)"unfSocCrdtNo"));
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)beginDate);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"20");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)pageTag);
        return Packer.packToReqMsg("EYC4", body);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return new EBBankDetailResponse(this.parseDetail(request, responseStr));
    }

    private List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) {
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        BankAcnt reqAcnt = rqst.getAcnt();
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            if ("EGG0521".equals(rsp.getResponseCode())) {
                log.info("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801EGG0521, \u672c\u6b21\u67e5\u8be2\u7ed3\u675f.");
                return new ArrayList<DetailInfo>();
            }
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s", (String)"DetailImpl_8", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalCount = JDomUtils.getChildText((Element)body, (String)"totalNumber");
        if (StringUtils.isEmpty((String)totalCount)) {
            totalCount = ParserUtils.getUnNullElementTextValue((Element)body, (String)"totalCount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u603b\u7b14\u6570", (String)"DetailImpl_1", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
        }
        int total = Integer.parseInt(totalCount);
        int nextPageTag = Integer.parseInt(this.getCurrentPage());
        this.setLastPage(nextPageTag >= total || total < 20);
        String acctNo = body.getChildText("acctNo");
        String currency = body.getChildText("currency");
        log.info("\u672c\u6b21\u8bf7\u6c42\u5e10\u53f7:" + reqAcnt.getAccNo());
        log.info("\u4ea4\u6613\u603b\u7b14\u6570:" + totalCount);
        log.info("\u5e10\u53f7:" + acctNo);
        log.info("\u5e10\u6237\u5e01\u79cd:" + currency);
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren();
        int count = localList.size();
        log.info("lists\u5305\u542b\u7684\u5b50\u8282\u70b9\u6570:" + count);
        ArrayList<DetailInfo> localArrayList = new ArrayList<DetailInfo>();
        for (int i = 0; i < count; ++i) {
            HashMap<String, Integer> countMap;
            Element element = (Element)localList.get(i);
            DetailInfo detail = this.parseDetail(element, reqAcnt, currency, countMap = new HashMap<String, Integer>());
            if (null == detail) continue;
            localArrayList.add(detail);
        }
        return localArrayList;
    }

    private DetailInfo parseDetail(Element element, BankAcnt acnt, String currency, Map<String, Integer> countMap) {
        String voucherNo = element.getChildText("voucherNo");
        String seqNo = element.getChildText("seqNo");
        String seqNum = element.getChildText("seqNum");
        String txAmount = ParserUtils.getUnNullElementTextValue((Element)element, (String)"txAmount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_2", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
        String balance = element.getChildText("balance");
        String tranFlag = ParserUtils.getUnNullElementTextValue((Element)element, (String)"tranFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7", (String)"DetailImpl_3", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
        String transDate = ParserUtils.getUnNullElementTextValue((Element)element, (String)"transDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_4", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
        String transTime = ParserUtils.getUnNullElementTextValue((Element)element, (String)"transTime", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"DetailImpl_5", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
        String note = element.getChildText("note");
        String remark = element.getChildText("remark");
        String payeeBankNo = element.getChildText("payeeBankNo");
        String payeeBankName = element.getChildText("payeeBankName");
        String payeeAcctNo = element.getChildText("payeeAcctNo");
        String payeeName = element.getChildText("payeeName");
        log.info("\u51ed\u8bc1\u53f7\uff1a" + voucherNo);
        log.info("\u4ea4\u6613\u6d41\u6c34\u53f7\uff1a" + seqNo);
        log.info("\u4ea4\u6613\u91d1\u989d\uff1a" + txAmount);
        log.info("\u5e10\u6237\u4f59\u989d\uff1a" + balance);
        log.info("\u501f\u8d37\u6807\u5fd7\uff1a" + tranFlag);
        log.info("\u4ea4\u6613\u65e5\u671f\uff1a" + transDate);
        log.info("\u4ea4\u6613\u65f6\u95f4\uff1a" + transTime);
        log.info("\u5907\u6ce8\uff1a" + note);
        log.info("\u6458\u8981\u4ee3\u7801\uff1a" + remark);
        log.info("\u5bf9\u65b9\u884c\u53f7\uff1a" + payeeBankNo);
        log.info("\u5bf9\u65b9\u884c\u540d\uff1a" + payeeBankName);
        log.info("\u5bf9\u65b9\u5e10\u53f7\uff1a" + payeeAcctNo);
        log.info("\u5bf9\u65b9\u6237\u540d\uff1a" + payeeName);
        log.info("******\r\n");
        DetailInfo detail = new DetailInfo();
        detail.setAccName(acnt.getAccName());
        detail.setAccNo(acnt.getAccNo());
        detail.setBankName(acnt.getBankName());
        int index = note.indexOf("_KD_");
        if (!StringUtils.isEmpty((String)note) && index != -1) {
            String bankDetailSeqId = BizNoUtil.getId((String)note);
            note = BizNoUtil.getMsg((String)note);
            detail.setKdFlag(bankDetailSeqId);
            detail.setPayBankDetailSeqID(bankDetailSeqId);
        }
        detail.setUseCn(note);
        detail.setCurrency(currency);
        if (!StringUtils.isEmpty((String)note.trim())) {
            detail.setExplanation(note);
        } else if (!StringUtils.isEmpty((String)remark.trim())) {
            detail.setExplanation(remark);
        } else {
            detail.setExplanation(ResManager.loadKDString((String)"(\u7a7a)", (String)"DetailImpl_6", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]));
        }
        BigDecimal currBal = this.convert(balance);
        if (null != currBal) {
            detail.setBalance(currBal);
        }
        BigDecimal amount = this.convert(txAmount);
        if ("0".equals(tranFlag)) {
            detail.setCreditAmount(new BigDecimal("0.00"));
            detail.setDebitAmount(amount);
        } else if ("1".equals(tranFlag)) {
            detail.setCreditAmount(amount);
            detail.setDebitAmount(new BigDecimal("0.00"));
        } else {
            log.info("\u8fd4\u56de\u672a\u77e5\u7684'\u501f\u8d37\u6807\u5fd7':" + tranFlag + ", \u672c\u6761\u6821\u9a8c\u660e\u7ec6\u4e0d\u5904\u7406, \u8bf7\u4eba\u5de5\u6838\u5b9e.");
            return null;
        }
        transTime = StringLength.fixed((String)transTime, (String)"0", (int)6, (boolean)false);
        detail.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        detail.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.BASIC_ISO_DATE));
        detail.setOppAccName(payeeName);
        detail.setOppAccNo(payeeAcctNo);
        detail.setOppBankName(payeeBankName);
        detail.setBankDetailNo(seqNo);
        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
        detail.setJsonMap(jsonStr);
        String accNo = acnt.getAccNo();
        String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
        if (countMap.containsKey(receiptNo)) {
            int count = countMap.get(receiptNo) + 1;
            countMap.put(receiptNo, count);
            receiptNo = receiptNo + "-" + String.format("%04d", count);
        } else {
            countMap.put(receiptNo, 0);
        }
        detail.setReceiptNo(receiptNo);
        return detail;
    }

    private BigDecimal convert(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            return new BigDecimal(str);
        }
        return null;
    }

    public String getDeveloper() {
        return "congmin_huang";
    }

    public String getBizCode() {
        return "EYC4";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u524d\u5e10\u6237\u660e\u7ec6(EYC4)", (String)"DetailImpl_7", (String)"ebg-aqap-banks-spdb-opa", (Object[])new Object[0]);
    }
}

