/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.payment.query;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryAndBatchPaymentQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    static String[] submiteds = new String[]{"A", "P", "R", "L", "W", "O"};

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 300;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("00003020104A0217", Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"start", (String)"1");
        JDomUtils.addChild((Element)body, (String)"size", (String)(paymentInfos.size() + ""));
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        Element array = body.getChild("array");
        if (array == null) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        List dtoList = array.getChildren("dto");
        HashMap<String, String> detailMap = new HashMap<String, String>(8);
        for (Element dto : dtoList) {
            detailMap.put(dto.getChildTextTrim("oppAcctNo") + dto.getChildTextTrim("amt"), dto.getChildTextTrim("tfrStat"));
        }
        HashMap<String, String> tfrStatMap = new HashMap<String, String>();
        tfrStatMap.put("A", ResManager.loadKDString((String)"\u5df2\u63a5\u6536", (String)"SalaryAndBatchPaymentQueryImpl_0", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("S", ResManager.loadKDString((String)"\u6210\u529f", (String)"SalaryAndBatchPaymentQueryImpl_1", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("F", ResManager.loadKDString((String)"\u5931\u8d25", (String)"SalaryAndBatchPaymentQueryImpl_2", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("P", ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"SalaryAndBatchPaymentQueryImpl_3", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("U", ResManager.loadKDString((String)"\u672a\u77e5", (String)"SalaryAndBatchPaymentQueryImpl_4", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("R", ResManager.loadKDString((String)"\u9884\u7ea6", (String)"SalaryAndBatchPaymentQueryImpl_5", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("C", ResManager.loadKDString((String)"\u64a4\u9500", (String)"SalaryAndBatchPaymentQueryImpl_6", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("L", ResManager.loadKDString((String)"\u843d\u5730", (String)"SalaryAndBatchPaymentQueryImpl_7", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("W", ResManager.loadKDString((String)"\u5de5\u5355", (String)"SalaryAndBatchPaymentQueryImpl_8", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        tfrStatMap.put("O", ResManager.loadKDString((String)"\u5916\u547c", (String)"SalaryAndBatchPaymentQueryImpl_9", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        for (PaymentInfo paymentInfo : paymentInfos) {
            String tfrStat = (String)detailMap.get(paymentInfo.getIncomeAccNo() + paymentInfo.getAmount());
            if (tfrStat == null) continue;
            if ("S".equals(tfrStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryAndBatchPaymentQueryImpl_10", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]), (String)tfrStat, (String)((String)tfrStatMap.get(tfrStat)));
                continue;
            }
            if ("F".equals(tfrStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryAndBatchPaymentQueryImpl_11", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]), (String)tfrStat, (String)((String)tfrStatMap.get(tfrStat)));
                continue;
            }
            if (Arrays.asList(submiteds).contains(tfrStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryAndBatchPaymentQueryImpl_12", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]), (String)tfrStat, (String)((String)tfrStatMap.get(tfrStat)));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryAndBatchPaymentQueryImpl_13", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]), (String)tfrStat, (String)((String)tfrStatMap.get(tfrStat)));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "00003020104A0217";
    }

    public String getBizDesc() {
        return "00003020104A0217";
    }
}

