/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.batch.BatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BatchPayImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BatchQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ZJRC_DC_Packer.getCommonHeader("100007", ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        Element iBatchOrderList = JDomUtils.addChild((Element)reqBody, (String)"iBatchOrderList");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element row = JDomUtils.addChild((Element)iBatchOrderList, (String)"row");
            JDomUtils.addChild((Element)row, (String)"payAccount", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)row, (String)"payAccountName", (String)((PaymentInfo)paymentInfos.get(i)).getAccName());
            JDomUtils.addChild((Element)row, (String)"recAccount", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"recAccountOpenBank", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)row, (String)"recBankType", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? "0" : "1"));
            JDomUtils.addChild((Element)row, (String)"transferTowardType", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameCity() ? "0" : "1"));
            JDomUtils.addChild((Element)row, (String)"payAmount", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"payUse", (String)BatchPayImpl.getExplanationForSalary((PaymentInfo)paymentInfos.get(i)));
            JDomUtils.addChild((Element)row, (String)"payRem", (String)((PaymentInfo)paymentInfos.get(i)).getUseCn());
            JDomUtils.addChild((Element)row, (String)"unionBankNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            JDomUtils.addChild((Element)row, (String)"tranMate", (String)(((PaymentInfo)paymentInfos.get(i)).is2Individual() ? "0" : "1"));
            JDomUtils.addChild((Element)row, (String)"orderNo", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId());
        }
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        String batchNo = JDomUtils.getChildText((Element)resBody, (String)"batchNo");
        if (null == batchNo) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7\u672a\u77e5\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"BatchPayImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        } else {
            Element bsnList = JDomUtils.getChildElement((Element)resBody, (String)"bsnList");
            List rows = bsnList.getChildren("row");
            if (rows.size() > 0) {
                HashMap<String, String> infoMap = new HashMap<String, String>(16);
                for (int i = 0; i < rows.size(); ++i) {
                    String commFlowNo = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"commFlowNo");
                    String orderNo = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"orderNo");
                    if (StringUtils.isNotEmpty((String)orderNo)) {
                        PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)orderNo);
                        if (paymentInfo != null) {
                            paymentInfo.setBankRefID(commFlowNo);
                            continue;
                        }
                        this.logger.info("\u94f6\u884c\u8fd4\u56de\u7684orderNo\u4e3a{},\u65e0\u6cd5\u5339\u914d\u4ed8\u6b3e\u8bb0\u5f55", (Object)orderNo);
                        continue;
                    }
                    String payAccountNo = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"payAccountNo");
                    String recAccountNo = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"recAccountNo");
                    String amount = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"amount");
                    infoMap.put(payAccountNo + recAccountNo + amount, commFlowNo);
                }
                if (infoMap.size() > 0) {
                    this.matchPaymentInfo(infoMap, paymentInfos);
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6307\u4ee4\u5e8f\u53f7\u672a\u77e5\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"BatchPayImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void matchPaymentInfo(Map<String, String> infoMap, List<PaymentInfo> paymentInfos) {
        for (int i = 0; i < paymentInfos.size(); ++i) {
            String accNo = paymentInfos.get(i).getAccNo();
            String incomeAccNo = paymentInfos.get(i).getIncomeAccNo();
            String amount = paymentInfos.get(i).getAmount().toPlainString();
            String key = accNo + incomeAccNo + amount;
            if (infoMap.containsKey(key)) {
                paymentInfos.get(i).setBankRefID(infoMap.get(key));
                continue;
            }
            this.logger.info("\u901a\u8fc7\u8981\u7d20\u5339\u914dkey{}\u65e0\u6cd5\u5339\u914d\u4ed8\u6b3e\u8bb0\u5f55", (Object)key);
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6307\u4ee4\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"BatchPayImpl_4", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        }
    }

    public static String getExplanationForSalary(PaymentInfo info) {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation());
        }
        return info.getExplanation();
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u4ed8\u6b3e", (String)"BatchPayImpl_5", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

