/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.individual;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ZJRC_DC_Packer.getCommonHeader("100008", ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"payAccount", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        if (((PaymentInfo)paymentInfos.get(0)).getUseCn().indexOf(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"IndividualPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0])) != -1) {
            JDomUtils.addChild((Element)reqBody, (String)"type", (String)"1");
        } else {
            JDomUtils.addChild((Element)reqBody, (String)"type", (String)"2");
        }
        JDomUtils.addChild((Element)reqBody, (String)"payMonth", (String)new SimpleDateFormat("MM").format(new Date()));
        JDomUtils.addChild((Element)reqBody, (String)"bdrantCode", (String)"9121");
        Element iSalaryRecordList = JDomUtils.addChild((Element)reqBody, (String)"iSalaryRecordList");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element row = JDomUtils.addChild((Element)iSalaryRecordList, (String)"row");
            JDomUtils.addChild((Element)row, (String)"employeeId", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId());
            JDomUtils.addChild((Element)row, (String)"employeeName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"cardNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"payAmount", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"comment", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
        }
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
            String batchNo = JDomUtils.getChildText((Element)resBody, (String)"batchNo");
            if (null == batchNo) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u6279\u6b21\u6d41\u6c34\u53f7", (String)"IndividualPayImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualPayImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u79c1\u4ed8\u6b3e", (String)"IndividualPayImpl_4", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

