/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.payment;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JsonObject body = new JsonObject();
        body.addProperty("transId", ((PaymentInfo)paymentInfos.get(0)).getBankDetailSeqID());
        String request = XMB_Packer.createHeadRoot("IESI109008", body);
        return XMB_Packer.sign(request);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        logger.info("\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a" + s);
        BankResponse rsp = XMB_Parser.paseHeadRoot(s);
        logger.info("\u94f6\u884c\u8fd4\u56de\u7801\u4e3a" + rsp.getResponseCode() + "\uff0c\u89e3\u6790\u5b8c\u6210------------\uff01");
        String responseCode = rsp.getResponseCode();
        String responseMessage = rsp.getResponseMessage();
        if ("00000".equalsIgnoreCase(responseCode) || "000000".equals(rsp.getResponseCode())) {
            String errMsg;
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(s).getAsJsonObject();
            JsonObject body = jsonObject.get("body").getAsJsonObject();
            int transStatus = body.get("transStatus").getAsInt();
            String errCode = body.get("errCode") == null ? "" : body.get("errCode").getAsString();
            String string = errMsg = body.get("errMsg") == null ? "" : body.get("errMsg").getAsString();
            if (transStatus == 0) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryImpl_0", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)responseMessage);
            } else if (transStatus == 2) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryImpl_1", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)(responseMessage + "||" + errMsg));
            } else if (transStatus == 1) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryImpl_2", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)(responseMessage + "||" + errMsg));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)(responseMessage + "||" + errMsg));
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMessage);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "IESI109008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"5.8\u8f6c\u8d26\u72b6\u6001\u67e5\u8be2(IESI109008)", (String)"QueryImpl_4", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }
}

