/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.payment.allocation;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.banks.xib.dc.service.payment.QueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JsonObject body = new JsonObject();
        body.addProperty("transId", paymentInfo.getBankDetailSeqID());
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]).equalsIgnoreCase(paymentInfo.getUseCn())) {
            body.addProperty("parCorpAcctNo", paymentInfo.getAccNo());
            body.addProperty("subCorpAcctNo", paymentInfo.getIncomeAccNo());
            body.addProperty("transType", (Number)5);
        } else {
            body.addProperty("parCorpAcctNo", paymentInfo.getIncomeAccNo());
            body.addProperty("subCorpAcctNo", paymentInfo.getAccNo());
            body.addProperty("transType", (Number)4);
        }
        body.addProperty("amount", paymentInfo.getAmount() + "");
        body.addProperty("currency", "CNY");
        String exp = paymentInfo.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            exp = exp + "KD@" + paymentInfo.getBankDetailSeqID();
        }
        body.addProperty("addtlInf", exp);
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109007", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        String retMsgDecoded = rspStr;
        BankResponse rsp = XMB_Parser.paseHeadRoot(retMsgDecoded);
        if ("00000".equalsIgnoreCase(rsp.getResponseCode())) {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(retMsgDecoded).getAsJsonObject();
            JsonObject body = jsonObject.get("body").getAsJsonObject();
            int transStatus = body.get("transStatus").getAsInt();
            if (transStatus == 0) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else if (transStatus == 1) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else if (transStatus == 2) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getBizCode() {
        return "IESI109007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d44\u91d1\u5f52\u96c6\u4e0a\u5212/\u4e0b\u62e8\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String getDeveloper() {
        return "HSQ";
    }
}

