/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.opa.services.PackerHelper;
import kd.ebg.aqap.banks.pab.opa.services.PageUtil;
import kd.ebg.aqap.banks.pab.opa.services.ParserHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Result, (String)"CcyType", (String)"");
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)request.getBankCurrency());
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "4001", xmlStr, request.getHeader().getCustomerID());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String account = root.getChildTextTrim("Account");
        String ccyCode = root.getChildTextTrim("CcyCode");
        String ccyType = root.getChildTextTrim("CcyType");
        String AccountName = root.getChildTextTrim("AccountName");
        String bal = root.getChildTextTrim("Balance");
        String totalAmount = root.getChildTextTrim("TotalAmount");
        String accountType = root.getChildTextTrim("AccountType");
        String accountStatus = root.getChildTextTrim("AccountStatus");
        String holdBalance = root.getChildTextTrim("HoldBalance");
        String stopBalance = root.getChildTextTrim("StopBalance");
        String lastBalance = root.getChildTextTrim("LastBalance");
        String hRate1 = root.getChildTextTrim("HRate1");
        String xDRate2 = root.getChildTextTrim("XDRate2");
        if (!request.getAcnt().getAccNo().equalsIgnoreCase(account)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), request.getAcnt().getAccNo(), account));
        }
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(request.getAcnt());
        balance.setBankCurrency(ccyCode);
        balance.setCurrentBalance(new BigDecimal(totalAmount));
        if (!StringUtils.isEmpty((String)bal)) {
            balance.setAvailableBalance(new BigDecimal(bal));
        }
        balance.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u5e10\u6237\u5355\u5e10\u6237\u4f59\u989d\u67e5\u8be2 [4001]", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]);
    }
}

