/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.sign.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import kd.bos.orm.util.ReflectionUtils;
import kd.ebg.egf.common.log.EBGLogger;

public class StringTool {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(StringTool.class);

    public static String getString(Object o) {
        return StringTool.getString(o, "gbk");
    }

    public static String getString(Object o, String encoding) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            String s = null;
            try {
                s = new String((byte[])o, encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.info(e.toString());
                return null;
            }
            return s;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public static String fillChar(String sSource, char ch, int nLen, boolean bLeft) {
        int nSrcLen = sSource.length();
        if (nSrcLen <= nLen) {
            StringBuilder buffer = new StringBuilder();
            if (bLeft) {
                for (int i = 0; i < nLen - nSrcLen; ++i) {
                    buffer.append(ch);
                }
                buffer.append(sSource);
            } else {
                buffer.append(sSource);
                for (int i = 0; i < nLen - nSrcLen; ++i) {
                    buffer.append(ch);
                }
            }
            return buffer.toString();
        }
        return sSource;
    }

    public static String getErrorStack(Throwable e) {
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        logger.info(e.toString());
        pw.close();
        return buf.getBuffer().toString();
    }

    public static StringBuilder printObject(Object source, Class clz) {
        StringBuilder sb = new StringBuilder();
        Field[] fs = clz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            String name = fs[i].getName();
            ReflectionUtils.makeAccessible((Field)fs[i]);
            if (Modifier.isStatic(fs[i].getModifiers())) continue;
            try {
                Object obj = fs[i].get(source);
                if (name.indexOf("password") >= 0 || name.indexOf("pwd") >= 0) {
                    obj = "***";
                }
                if (obj instanceof Object[]) {
                    Object[] o = (Object[])obj;
                    sb.append("\n").append(name).append("=[");
                    if (o.length > 0) {
                        sb.append(StringTool.getString(o[0]));
                    }
                    for (int j = 1; j < o.length; ++j) {
                        sb.append(",").append(StringTool.getString(o[j]));
                    }
                    sb.append("]");
                    continue;
                }
                sb.append("\n").append(name).append("=").append(StringTool.getString(obj));
                continue;
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }
        return sb;
    }
}

