/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.utils.CommonUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final int pageSize = 100;

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList detailList = new ArrayList(16);
        this.setCurrentPage("1");
        this.setLastPage(false);
        try {
            while (!this.isLastPage()) {
                String requestStr = this.pack(request);
                Preconditions.checkNotNull((Object)requestStr, (Object)ResManager.loadKDString((String)"\u6253\u5305\u540e\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e0d\u80fd\u4e3anull", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
                String responseStr = new CommonUtil().sendToBank(this.getBizCode(), requestStr);
                EBBankDetailResponse response = this.parse(request, responseStr);
                detailList.addAll(response.getDetails());
            }
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception var14) {
            this.logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25", (Throwable)var14);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25", (String)"DetailImpl_1", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), (Throwable)var14);
        }
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String pageTag = this.getCurrentPage();
        if ("0".equals(pageTag)) {
            pageTag = "1";
            this.setCurrentPage(pageTag);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serialNo", (Object)Sequence.gen18Sequence());
        jsonObject.put("cid", (Object)EBContext.getContext().getParameter().getBankParameter("cust_no"));
        jsonObject.put("acctNo", (Object)bankDetailRequest.getAcnt().getAccNo());
        jsonObject.put("beginRecordNo", (Object)pageTag);
        jsonObject.put("recorNum", (Object)"100");
        if (LocalDate.now().equals(bankDetailRequest.getStartDate()) && LocalDate.now().equals(bankDetailRequest.getEndDate())) {
            jsonObject.put("dataFlag", (Object)"0");
        } else {
            jsonObject.put("dataFlag", (Object)"1");
            jsonObject.put("beginDate", (Object)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate()));
            jsonObject.put("endDate", (Object)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate()));
        }
        jsonObject.put("sortType", (Object)"1");
        jsonObject.put("trnType", (Object)"2");
        jsonObject.put("reexchangeType", (Object)"0");
        return jsonObject.toJSONString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)msg);
        }
        if (!this.isLastPage(jsonObject)) {
            int nextPageTag = Integer.parseInt(this.getCurrentPage()) + 100;
            this.setCurrentPage(nextPageTag);
        } else {
            this.setLastPage(true);
        }
        JSONArray detailJson = jsonObject.getJSONArray("tranList");
        int count = detailJson == null ? 0 : detailJson.size();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < count; ++i) {
            DetailInfo detailInfo = new DetailInfo();
            JSONObject obj = detailJson.getJSONObject(i);
            String uniqueSerialNo = obj.getString("uniqueSerialNo");
            String dateStr = obj.getString("date");
            String timeStr = obj.getString("time");
            BigDecimal balance = obj.getBigDecimal("balAmt");
            BigDecimal amount = obj.getBigDecimal("trnAmt");
            String bankCurrency = obj.getString("currency");
            String dcFlag = obj.getString("trnType");
            String oppAccNo = obj.getString("correlateAcctNo");
            String oppAccName = obj.getString("correlateName");
            String oppBankName = obj.getString("correlateBankName");
            String summary = obj.getString("remark");
            String useCn = obj.getString("purpose");
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setCurrency(bankCurrency);
            detailInfo.setOppAccNo(oppAccNo);
            detailInfo.setOppAccName(oppAccName);
            detailInfo.setOppBankName(oppBankName);
            detailInfo.setDebitAmount("0".equals(dcFlag) ? amount : BigDecimal.ZERO);
            detailInfo.setCreditAmount("1".equals(dcFlag) ? amount : BigDecimal.ZERO);
            detailInfo.setBalance(balance);
            detailInfo.setExplanation(summary);
            detailInfo.setUseCn(useCn);
            detailInfo.setTransDate(LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detailInfo.setTransTime(LocalDateTime.parse(dateStr + timeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            StringBuilder uniqueSeq = new StringBuilder();
            uniqueSeq.append(detailInfo.getAccNo()).append("|").append(dateStr).append("|").append(uniqueSerialNo);
            detailInfo.setReceiptNo(uniqueSeq.toString());
            detailInfo.setBankDetailNo(uniqueSerialNo);
            String jsonStr = obj.toJSONString();
            detailInfo.setJsonMap(jsonStr);
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    public boolean isLastPage(JSONObject jsonObject) {
        String totalNum = jsonObject.getString("totalNum");
        String startNo = this.getCurrentPage();
        return Integer.parseInt(startNo) + 100 > Integer.parseInt(totalNum);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "/api/dcfirmSAAS/queryAccountFlow";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u6216\u5386\u53f2\u660e\u7ec6", (String)"DetailImpl_2", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
    }
}

