/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.detail.DetailPage;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        if (currentPage == null || "0".equals(currentPage)) {
            this.setCurrentPage(1);
        }
        return this.packRequest(bankDetailRequest);
    }

    private String packRequest(BankDetailRequest bankDetailRequest) {
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        Element body = JDomUtils.createRoot((String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate()));
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"size", (String)"15");
        return PackHelper.getPackMessage("01603020101A0007", Sequence.genSequence(), body);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        if (DetailPage.isLastPage(res)) {
            this.setLastPage(true);
        } else {
            int page = Integer.parseInt(this.getCurrentPage()) + 15;
            this.setCurrentPage(page);
        }
        ParserHelper.judgeHeadMessage(res);
        List<DetailInfo> detailList = this.getDetailList(bankDetailRequest, res);
        return new EBBankDetailResponse(detailList);
    }

    private List<DetailInfo> getDetailList(BankDetailRequest bankDetailRequest, String res) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element body = ParserHelper.getBodyMessage(res);
        if (body.getChild("array") == null) {
            return detailList;
        }
        Element array = body.getChild("array");
        List dtos = array.getChildren("dto");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Element element : dtos) {
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setCurrency(element.getChildText("currency"));
            BankAcnt bankAcnt = bankDetailRequest.getAcnt();
            detailInfo.setAccNo(bankAcnt.getAccNo());
            detailInfo.setBankVersionID(bankAcnt.getBankVersionId());
            detailInfo.setBankLoginID(bankAcnt.getBankLoginId());
            detailInfo.setBankName(bankAcnt.getBankName());
            detailInfo.setAccName(bankAcnt.getAccName());
            String trDate = element.getChildText("trDate");
            String trTime = element.getChildText("trTime");
            LocalDate localDate = LocalDateUtil.parserDate((String)trDate);
            detailInfo.setTransDate(localDate);
            if (StringUtils.isEmpty((String)trTime)) {
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(trDate + "000000")));
            } else {
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(trDate + trTime)));
            }
            String flag = element.getChildText("drcrFlag");
            BigDecimal amt = BigDecimal.ZERO;
            if (!StringUtils.isEmpty((String)element.getChildText("amt"))) {
                amt = new BigDecimal(element.getChildText("amt"));
            }
            if ("C".equals(flag)) {
                detailInfo.setCreditAmount(amt);
                detailInfo.setDebitAmount(BigDecimal.ZERO);
            } else if ("D".equals(flag)) {
                detailInfo.setDebitAmount(amt);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
            }
            detailInfo.setBalance(BigDecimalHelper.str2BigDecimalForBalance((String)element.getChildText("balance"), (Boolean)true));
            detailInfo.setOppAccName(element.getChildText("oppAcctName"));
            detailInfo.setOppBankName(element.getChildText("oppBankName"));
            detailInfo.setOppAccNo(element.getChildText("oppAcctNo"));
            detailInfo.setExplanation(element.getChildText("summary"));
            detailInfo.setHistory(Boolean.TRUE);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(element.getChildText("hostSerialNo"));
            String accNo = bankDetailRequest.getAcnt().getAccNo();
            Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
            if ("C".equals(flag)) {
                jsonMap.put("drcrFlag", "1");
            } else if ("D".equals(flag)) {
                jsonMap.put("drcrFlag", "0");
            }
            jsonMap.put("amt", amt.setScale(2).toPlainString());
            jsonStr = JsonUtil.toJson((Object)jsonMap);
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, trDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailList.add(detailInfo);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603020101A0007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

