/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.payment.salary;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImplWithPage;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImplWithPage
implements IQueryPay {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element body = JDomUtils.createRoot((String)"body");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pager", (String)"true");
        JDomUtils.addChild((Element)body, (String)"size", (String)"10");
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        return PackHelper.getPackMessage("01603020104A0217", Sequence.genSequence(), body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        this.parseQueryPay(bankPayRequest.getPaymentInfoAsArray(), res);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        this.setLastPage(true);
        BankResponse rsp = ParserHelper.buildHeadMessage(rspStr);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            for (PaymentInfo paymentInfo : paymentInfos) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u652f\u4ed8\u7ed3\u679c\u5931\u8d25\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        } else {
            Element body = ParserHelper.getBodyMessage(rspStr);
            if (body.getChild("array") == null) {
                return;
            }
            String total = body.getChildText("total");
            this.handPage(total);
            HashMap<String, Element> detailMap = new HashMap<String, Element>(16);
            Element array = body.getChild("array");
            List dtos = array.getChildren("dto");
            for (Element element : dtos) {
                String oppAcctNo = element.getChildText("oppAcctNo");
                String oppAcctName = element.getChildText("oppAcctName");
                String amt = element.getChildText("amt");
                BigDecimal amount = new BigDecimal(amt).setScale(2);
                StringBuilder matchKey = new StringBuilder();
                matchKey.append(oppAcctNo).append(oppAcctName).append(amount.toPlainString());
                detailMap.put(matchKey.toString(), element);
            }
            this.logger.info("\u5339\u914d\u6570\u636e\u4e3a==" + ((Object)detailMap).toString());
            for (PaymentInfo paymentInfo : paymentInfos) {
                String incomeAccNo = paymentInfo.getIncomeAccNo();
                String incomeName = paymentInfo.getIncomeAccName();
                String amount = paymentInfo.getAmount().toPlainString();
                StringBuilder payMatchKey = new StringBuilder();
                payMatchKey.append(incomeAccNo).append(incomeName).append(amount);
                Element element = (Element)detailMap.get(payMatchKey.toString());
                if (element == null) {
                    this.logger.info("\u5f53\u524dkey{}\u6ca1\u6709\u5339\u914d\u7684\u4ed8\u6b3e\u72b6\u6001", (Object)payMatchKey.toString());
                    continue;
                }
                String tfrStat = element.getChildText("tfrStat");
                if ("S".equals(tfrStat)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                    continue;
                }
                if ("F".equals(tfrStat)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                    continue;
                }
                if ("P".equals(tfrStat)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                    continue;
                }
                if ("A".equals(tfrStat)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5df2\u63a5\u6536", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                    continue;
                }
                if ("U".equals(tfrStat)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603020104A0217";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u6279\u6b21\u660e\u7ec6\u67e5\u8be2", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public Boolean SupportPage() {
        return true;
    }

    private void handPage(String total) {
        if (StringUtils.isNotEmpty((String)total)) {
            int totalCount = Integer.parseInt(total);
            String currentPage = this.getCurrentPage();
            int count = Integer.parseInt(currentPage) + 10;
            if (count - 1 < totalCount) {
                this.setLastPage(false);
                this.setCurrentPage(count);
                return;
            }
        }
        this.setLastPage(true);
    }
}

