/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.dbs.dc.services.utils.PgpHelper;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import sun.net.www.protocol.https.Handler;

public class DBS_DC_Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DBS_DC_Packer.class);

    public static JSONObject createHeader(String accNo, String country) {
        JSONObject header = new JSONObject();
        header.put("msgId", (Object)Sequence.genSequence());
        header.put("orgId", (Object)BankBusinessConfig.getCompanyId(accNo));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        header.put("timeStamp", (Object)format.format(new Date()));
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code && (code = ISOCountryUtils.getInstance().getCountryInfo(country)) == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7801\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"DBS_DC_Packer_3", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), country));
        }
        header.put("ctry", (Object)code.geteChart2());
        return header;
    }

    public static JSONObject createHeaderForFastPay(String accNo) {
        JSONObject header = new JSONObject();
        header.put("msgId", (Object)Sequence.genSequence());
        header.put("orgId", (Object)BankBusinessConfig.getCompanyId(accNo));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        header.put("timeStamp", (Object)format.format(new Date()));
        return header;
    }

    public static String packAck(PaymentInfo info) {
        Element simulator = new Element("simulator");
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"token", (String)"");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)info.getBankDetailSeqID());
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"itemSequence", (String)info.getBankDetailSeqId());
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public static HttpsURLConnection createConnection(String uri, String accNo) throws KeyManagementException, IOException, NoSuchAlgorithmException {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        URL urlStr = new URL("https", ip, Integer.parseInt(port), uri);
        URL url = new URL(null, urlStr.toString(), new Handler());
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(sc.getSocketFactory());
        conn.setDoInput(true);
        conn.setConnectTimeout(2000);
        conn.setReadTimeout(Integer.parseInt(timeOut) * 60 * 1000);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setRequestProperty("x-api-key", BankBusinessConfig.getApiKeyId(accNo));
        conn.setRequestProperty("X-DBS-ORG_ID", BankBusinessConfig.getCompanyId(accNo));
        conn.connect();
        return conn;
    }

    public static String packFastPayment(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject total = new JSONObject();
        JSONObject header = DBS_DC_Packer.createHeaderForFastPay(info.getAccNo());
        JSONObject txnInfo = new JSONObject();
        txnInfo.put("customerReference", (Object)info.getBankDetailSeqId());
        txnInfo.put("txnType", (Object)"GPP");
        txnInfo.put("txnDate", (Object)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        txnInfo.put("txnCcy", (Object)info.getCurrency());
        txnInfo.put("txnAmount", (Object)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
        JSONObject senderParty = new JSONObject();
        senderParty.put("name", (Object)info.getAccName());
        senderParty.put("accountNo", (Object)info.getAccNo());
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(info.getAccCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(info.getAccCountry());
        }
        senderParty.put("bankCtryCode", (Object)code.geteChart2());
        senderParty.put("swiftBic", (Object)RequestContextUtils.getBankParameterValue((String)"swiftBic"));
        txnInfo.put("senderParty", (Object)senderParty);
        JSONObject receivingParty = new JSONObject();
        receivingParty.put("name", (Object)info.getIncomeAccName());
        receivingParty.put("accountNo", (Object)info.getIncomeAccNo());
        CountryISOCode incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry());
        if (incomeIsoCode == null) {
            incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
        }
        receivingParty.put("bankCtryCode", (Object)incomeIsoCode.geteChart2());
        receivingParty.put("swiftBic", (Object)info.getIncomeSwiftCode());
        txnInfo.put("receivingParty", (Object)receivingParty);
        JSONObject rmtInf = new JSONObject();
        JSONArray paymentDetails = new JSONArray();
        String exp = info.getExplanation();
        if (!StringUtils.isEmpty((String)exp)) {
            JSONObject paymentDetail = new JSONObject();
            if (exp.length() > 35) {
                paymentDetail.put("paymentDetail", (Object)exp.substring(0, 35));
                exp = exp.substring(35, exp.length() > 70 ? 70 : exp.length());
                JSONObject paymentDetail2 = new JSONObject();
                paymentDetail2.put("paymentDetail", (Object)exp);
                paymentDetails.add((Object)paymentDetail2);
            } else {
                paymentDetail.put("paymentDetail", (Object)exp);
            }
            paymentDetails.add((Object)paymentDetail);
        }
        rmtInf.put("paymentDetails", (Object)paymentDetails);
        txnInfo.put("rmtInf", (Object)rmtInf);
        total.put("header", (Object)header);
        total.put("txnInfo", (Object)txnInfo);
        try {
            return PgpHelper.encry(total.toJSONString());
        }
        catch (Throwable e) {
            logger.error("\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"DBS_DC_Packer_2", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

