/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services.payment.local;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.dc.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.dc.services.utils.PgpHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryFastPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryFastPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String response = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"payFastUri"), ((PaymentInfo)paymentInfos.get(0)).getAccNo(), this.pack(request));
        return this.parse(request, response);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return DBS_DC_Packer.packFastPayment(bankPayRequest);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String origin;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            origin = PgpHelper.decry(s);
        }
        catch (Throwable e) {
            this.logger.error("\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"QueryFastPayImpl_0", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return this.parseInfo(origin, paymentInfos);
    }

    public EBBankPayResponse parseInfo(String origin, List<PaymentInfo> paymentInfos) {
        JSONObject total = JSONObject.parseObject((String)origin);
        DBS_DC_Parser.checkError(total);
        JSONObject txnResponses = total.getJSONObject("txnResponse");
        String txnStatus = txnResponses.getString("txnStatus");
        String txnStatusDescription = txnResponses.getString("txnStatusDescription");
        String txnRejectCode = txnResponses.getString("txnRejectCode");
        if ("RJCT".equalsIgnoreCase(txnStatus) && "I103".equalsIgnoreCase(txnRejectCode)) {
            if (txnStatusDescription.contains("ACTC")) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryFastPayImpl_1", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)txnStatus, (String)txnStatusDescription);
            } else if (txnStatusDescription.contains("RJCT")) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryFastPayImpl_2", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)txnRejectCode, (String)txnStatusDescription);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryFastPayImpl_3", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), (String)txnStatus, (String)txnStatusDescription);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

