/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dc.services.payment;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dc.services.HDBCommParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EPaymentStatQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"List");
        Element mapElement = JDomUtils.addChild((Element)listElement, (String)"Map");
        JDomUtils.addChild((Element)mapElement, (String)"OldJnlNo", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)mapElement, (String)"OldTrsDate", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"PayAcnt", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"RcvAcnt", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"Amount", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"CifNo", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"AcNo", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"Priority", (String)"");
        JDomUtils.addChild((Element)mapElement, (String)"Bak1", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse resp = HDBCommParser.parserCommonHead(s);
        if (!"000000".equals(resp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\u3002", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (String)resp.getResponseCode(), (String)resp.getResponseMessage());
        }
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element mapElement = root.getChild("Body").getChild("List").getChild("Map");
        String returnCode = mapElement.getChildTextTrim("ReturnCode");
        String returnMsg = mapElement.getChildTextTrim("ReturnMsg");
        if (!"000000".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de,\u4ea4\u6613\u672a\u786e\u8ba4\u3002", (String)"QryPaymentImpl_1", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        String tranStat = mapElement.getChildTextTrim("TranStat");
        if ("0".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)tranStat, (String)resp.getResponseMessage());
        } else if ("1".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)tranStat, (String)resp.getResponseMessage());
        } else if ("A".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)tranStat, (String)resp.getResponseMessage());
        } else if ("11".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)tranStat, (String)resp.getResponseMessage());
        } else if ("4".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)tranStat, (String)resp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)tranStat, (String)resp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EPaymentStatQry";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder();
        uri.append("/eweb/").append(this.getBizCode()).append(".do?");
        String accessNumber = RequestContextUtils.getBankParameterValue((String)"passWord");
        String signFlag = "1";
        uri.append("userPassword=").append(accessNumber).append("&SIGDATA=").append(signFlag);
        factory.setUri(uri.toString());
    }
}

