/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceParser.class);

    public static EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        BalanceImpl impl = new BalanceImpl();
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = ebenk.getChild("head");
        String retcode = head.getChildText("ret_code");
        String succ_flag = head.getChildText("succ_flag");
        if (!"0000".equalsIgnoreCase(retcode) || !"0".equalsIgnoreCase(succ_flag)) {
            String ret_info = head.getChildText("ret_info");
            String ext_info = head.getChildText("ext_info");
            String resMsg = ShowTipUtil.getResponseErrorTips((String)(retcode + succ_flag), (String)(ret_info + ext_info));
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element body = ebenk.getChild("body");
        impl.setBankAcnt(balanceInfo, rqst.getBankAcntList(), body.getChildText("acno"));
        impl.setCurrentBalance(balanceInfo, body.getChildText("balance"));
        impl.setAvailableBalance(balanceInfo, body.getChildText("use_balance"));
        String currency = body.getChildText("cur_code");
        impl.setBankCurrency(balanceInfo, rqst.getBankCurrency(), currency);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceRsp.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return balanceRsp;
    }

    public static EBBankBalanceResponse cashPoolParse(BankBalanceRequest rqst, String rspStr) {
        String content;
        int fieldNum;
        int recordNum;
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = ebenk.getChild("head");
        String retcode = head.getChildText("ret_code");
        String succ_flag = head.getChildText("succ_flag");
        if ("0000".equalsIgnoreCase(retcode) && "0".equalsIgnoreCase(succ_flag)) {
            Element body = ebenk.getChild("body");
            String record_num = body.getChildTextTrim("record_num");
            String field_num = body.getChildTextTrim("field_num");
            recordNum = -1;
            if (!StringUtils.isEmpty((String)record_num)) {
                recordNum = Integer.parseInt(record_num);
            }
            fieldNum = -1;
            if (!StringUtils.isEmpty((String)field_num)) {
                fieldNum = Integer.parseInt(field_num);
            }
            content = null;
            if (recordNum <= 0) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"BalanceParser_6", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            }
            if ("0".equals(head.getChildTextTrim("file_flag"))) {
                String serial_record;
                logger.info("\u8fd4\u56de\u7684\u662f\u62a5\u6587\uff0c\u4eceserial_record\u91cc\u9762\u62ff\u5230\u4fe1\u606f");
                content = serial_record = body.getChildTextTrim("serial_record");
            } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
                logger.info("\u8fd4\u56de\u7684\u662f\u6587\u4ef6");
                String file_name = body.getChildTextTrim("file_name");
                content = IOUtils.downloadFileFromLocal(file_name);
            } else {
                logger.info("\u6587\u4ef6\u6807\u8bc6\uff1a" + head.getChildTextTrim("file_flag"));
            }
        } else {
            String ret_info = head.getChildText("ret_info");
            String ext_info = head.getChildText("ext_info");
            String resMsg = ShowTipUtil.getResponseErrorTips((String)(retcode + succ_flag), (String)(ret_info + ext_info));
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
        EBBankBalanceResponse balanceRsp = BalanceParser.parseEachCPBalances(rs, rqst.getAcnt());
        return balanceRsp;
    }

    static EBBankBalanceResponse parseEachCPBalances(String[][] fields, BankAcnt acnt) {
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        BalanceInfo balance = BalanceParser.parseEachCPBalance(fields[0], acnt);
        rsp.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
        return rsp;
    }

    public static BalanceInfo parseEachCPBalance(String[] fields, BankAcnt acnt) {
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(acnt);
        balance.setBalanceDateTime(LocalDateTime.now());
        String cur = fields[1];
        String selfBal = fields[4];
        String SelfUpBal = fields[3];
        BalanceUtil.setCurrentBalance((BalanceInfo)balance, (String)selfBal);
        BalanceUtil.setBankCurrency((BalanceInfo)balance, (String)BalanceParser.covertCur(cur));
        BalanceUtil.setAvailableBalance((BalanceInfo)balance, (String)SelfUpBal);
        return balance;
    }

    public static String covertCur(String cur) {
        if (StringUtils.isEmpty((String)cur)) {
            return "";
        }
        if ("CNY".equalsIgnoreCase(cur.trim())) {
            return "01";
        }
        return cur.trim();
    }
}

