/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.otherbank.batch.straight;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.services.payment.otherbank.batch.straight.OtherBankBatchStraightQueryPayImpl;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankBatchStraightPaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OtherBankBatchStraightPaymentImpl.class);
    private final String TRANCODE2 = "300910";

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OtherBankBatchStraightQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2("300910", paymentInfos, "1"));
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)body, (String)"acno", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)paymentInfos[0].getCurrency());
        StringBuilder content = new StringBuilder("pay_acno|pay_acname|pay_bank_no|pay_bank_name|amt|postscript|contractno|\r\n");
        BigDecimal totalamt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            content.append(paymentInfos[i].getAccNo()).append("|").append(paymentInfos[i].getAccName()).append("|").append(paymentInfos[i].getIncomeAccNo()).append("|").append(paymentInfos[i].getIncomeBankName()).append("|").append(paymentInfos[i].getAmount()).append("|").append(paymentInfos[i].getExplanation()).append("|").append(PropertiesConstants.getValue((String)"XTCJWYH")).append("\r\n");
            totalamt = totalamt.add(paymentInfos[i].getAmount());
        }
        JDomUtils.addChild((Element)body, (String)"amt", (String)String.valueOf(totalamt));
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)PropertiesConstants.getValue((String)"XTPOSTSCRIPT"));
        JDomUtils.addChild((Element)body, (String)"field_num", (String)"");
        JDomUtils.addChild((Element)body, (String)"record_num", (String)"");
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMddHHmmss");
        String file_name = bankBatchSeqId + "@" + date;
        IOUtils.uploadFileFromLocal(file_name, content.toString());
        while (!IOUtils.isuploaded(file_name)) {
            try {
                this.logger.info("\u672a\u627e\u5230\u6587\u4ef6\uff0c\u7b49\u5f853\u79d2...");
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        JDomUtils.addChild((Element)body, (String)"file_name", (String)file_name);
        String requestXml = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(requestXml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300910";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d85\u7ea7\u7f51\u94f6\u8de8\u884c\u6279\u91cf\u6536\u6b3e", (String)"OtherBankBatchStraightPaymentImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

