/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.salary.batch;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryBatchQueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryBatchQueryPaymentImpl.class);
    private static final String transCode = "200201";

    public int getBatchSize() {
        return 50;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2(transCode, paymentInfos, "0"));
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfos[0].getBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)"");
        String cms_corp_no = RequestContextUtils.getParameter().getBankParameter("cms_corp_no");
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)cms_corp_no);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(requestMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(bankStatus)) {
            String record_num = body.getChildTextTrim("record_num");
            String field_num = body.getChildTextTrim("field_num");
            int recordNum = -1;
            if (!StringUtils.isEmpty((String)record_num)) {
                recordNum = Integer.parseInt(record_num);
            }
            int fieldNum = -1;
            if (!StringUtils.isEmpty((String)field_num)) {
                fieldNum = Integer.parseInt(field_num);
            }
            String content = null;
            if (recordNum <= 0) {
                logger.error("###\u672c\u6b21\u4ee3\u53d1\u5de5\u8d44\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
                return new EBBankPayResponse(paymentInfos);
            }
            if ("0".equals(head.getChildTextTrim("file_flag"))) {
                String serial_record;
                logger.info("\u8fd4\u56de\u7684\u662f\u62a5\u6587\uff0c\u4eceserial_record\u91cc\u9762\u62ff\u5230\u4fe1\u606f");
                content = serial_record = body.getChildTextTrim("serial_record");
            } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
                logger.info("\u8fd4\u56de\u7684\u662f\u6587\u4ef6");
                String file_name = body.getChildTextTrim("file_name");
                content = IOUtils.downloadFileFromLocal(file_name);
            }
            String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
            SalaryBatchQueryPaymentImpl.parsepayInfo(paymentInfos, rs);
        } else {
            logger.info("\u901a\u8baf\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + bankStatus);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private static void parsepayInfo(List<PaymentInfo> paymentInfos, String[][] rs) {
        for (int i = 0; i < rs.length; ++i) {
            String accnbr = rs[i][1];
            String trsamt = rs[i][5];
            String stat = rs[i][9];
            if (StringUtils.isEmpty((String)trsamt)) {
                logger.error("\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u91d1\u989dtrsamt\u4e3a\u7a7a");
                continue;
            }
            BigDecimal amount = new BigDecimal(trsamt.trim());
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)accnbr, (BigDecimal)(amount = amount.setScale(2)));
            if (null == paymentInfo) continue;
            logger.info("###\u672c\u6b21\u4ee3\u53d1\u5de5\u8d44\u67e5\u8be2\u8fd4\u56de\u72b6\u6001" + stat + ",\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + rs[i][10]);
            if ("9".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryBatchQueryPaymentImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)stat, (String)"");
                continue;
            }
            if ("6".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryBatchQueryPaymentImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)stat, (String)"");
                continue;
            }
            if ("0".equalsIgnoreCase(stat) || "2".equalsIgnoreCase(stat) || "3".equalsIgnoreCase(stat) || "4".equalsIgnoreCase(stat) || "5".equalsIgnoreCase(stat) || "A".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)stat, (String)"");
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)stat, (String)"");
        }
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u72b6\u6001\u67e5\u8be2", (String)"SalaryBatchQueryPaymentImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }
}

