/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.allocationtosamebank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.UseConvertor;
import kd.ebg.aqap.banks.cmb.dc.service.payment.allocationtosamebank.AllocationSameBankQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationSameBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationSameBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u7f57\u96f7", (String)"AllocationSameBankPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "NTLLMBRP";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u5927\u989d\u8d44\u91d1\u5212\u62e8", (String)"AllocationSameBankPayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u63a5\u53e3\u4e0d\u63a5\u53d7\u591a\u6bd4\u5212\u62e8", (String)"AllocationSameBankPayImpl_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element root = CMB_DC_Packer.packRoot("NTLLMBRP");
        Element ntllmbrpx = JDomUtils.addChild((Element)root, (String)"NTLLMBRPX");
        String accNo = paymentInfo.getAccNo();
        String incomeNo = paymentInfo.getIncomeAccNo();
        String amount = paymentInfo.getAmount().toString();
        String accNoNum = BankBusinessConfig.getNTLLMBRPCRSCOD(accNo);
        String incomeNoNum = BankBusinessConfig.getNTLLMBRPCRSCOD(incomeNo);
        if (StringUtils.isEmpty((String)accNoNum) || StringUtils.isEmpty((String)incomeNoNum)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\u4e3a\u7a7a", (String)"AllocationSameBankPayImpl_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        String brpdrt = "";
        if (!UseConvertor.isTransfer(paymentInfo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u4e0d\u662f\u4e0a\u5212\u4e0b\u62e8\u4ea4\u6613", (String)"AllocationSameBankPayImpl_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        if (UseConvertor.isTransUp(paymentInfo)) {
            brpdrt = "STP";
            JDomUtils.addChild((Element)ntllmbrpx, (String)"CRSCOD", (String)incomeNoNum);
            JDomUtils.addChild((Element)ntllmbrpx, (String)"CRPSEQ", (String)accNoNum);
        } else {
            brpdrt = "PTS";
            JDomUtils.addChild((Element)ntllmbrpx, (String)"CRSCOD", (String)accNoNum);
            JDomUtils.addChild((Element)ntllmbrpx, (String)"CRPSEQ", (String)incomeNoNum);
        }
        JDomUtils.addChild((Element)ntllmbrpx, (String)"BRPDRT", (String)brpdrt);
        JDomUtils.addChild((Element)ntllmbrpx, (String)"TRXAMT", (String)amount);
        JDomUtils.addChild((Element)ntllmbrpx, (String)"RSV50Z", (String)"");
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO(root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

