/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_QueryPayPacker;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_QueryPayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.company.ConfigHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "GetPaymentInfo";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e\u63a5\u53e3", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getImplClassName().equalsIgnoreCase(CompanyPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String buscod = ConfigHelper.instance().isDirectGroupPayAcnt(paymentInfo.getAccNo()) ? "N02041" : "N02031";
        return CMB_DC_QueryPayPacker.packQueryPay(paymentInfos, buscod, PaymentUtil.getYurRef(paymentInfo));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        CMB_DC_QueryPayParser.parseQueryBatchPay(paymentInfos, responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

