/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbcsg.dc;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static final PropertyConfigItem OCBC_SG_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("OCBC_SG_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_1", "ebg-aqap-banks-ocbcsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_2", "ebg-aqap-banks-ocbcsg-dc")})).build();
    private static final PropertyConfigItem pay_file_name = PropertyConfigItem.builder().key("pay_file_name").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u6587\u4ef6\u7684\u524d\u7f00", "BankBusinessConfig_3", "ebg-aqap-banks-ocbcsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4f18\u5148\u7ea7\u9ad8\u4e8e\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e,\u5f53\u94f6\u4f01\u8d26\u6237\u7684\u3010\u4ed8\u6b3e\u6587\u4ef6\u7684\u524d\u7f00\u3011\u65e0\u503c\u65f6\uff0c\u73b0\u6709\u903b\u8f91\u4e0d\u53d8\uff0c\u53d6\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u7684\u3010\u4ed8\u6b3e\u6587\u4ef6\u7684\u524d\u7f00\u3011\u3002\u5f53\u94f6\u4f01\u8d26\u6237\u7684\u3010\u4ed8\u6b3e\u6587\u4ef6\u7684\u524d\u7f00\u3011\u6709\u503c\u65f6\uff0c\u53d6\u94f6\u4f01\u8d26\u6237\u7684\u3010\u4ed8\u6b3e\u6587\u4ef6\u7684\u524d\u7f00\u3011", "BankBusinessConfig_4", "ebg-aqap-banks-ocbcsg-dc")})).isAccNo(true).build();

    public boolean isForeignBank() {
        return true;
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List configItemList = this.getBankAddtionalPropertyConfigItems(false, false, false);
        configItemList.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{OCBC_SG_PAY_STATE_TIMEOUT, pay_file_name}));
        return configItemList;
    }

    public static String getPayFilePrefix(String accNo) {
        return pay_file_name.getCurrentValueWithObjectID(accNo);
    }

    public static int getPayStateTimeout() {
        String timeOut = OCBC_SG_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != timeOut && timeOut.length() > 0) {
            try {
                if (Integer.parseInt(timeOut) > 0) {
                    timeout = Integer.parseInt(timeOut);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime deadlineTime = submitSuccessTime.plus(payStateTimeout, ChronoUnit.HOURS);
        return deadlineTime.isBefore(LocalDateTime.now());
    }
}

