/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FrontProxy
extends AbstractImpl {
    public Element createHead(String bizType) throws EBServiceException {
        return this.createHead(bizType, Sequence.genSequence());
    }

    public Element createHead(String bizType, String seqno) throws EBServiceException {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.format((Date)new Date(), (String)"HHmmss"));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public BankResponse parseHeader(Element root) throws EBServiceException {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"FrontProxy_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public String sendAndRecvMsg(String rqstStr) {
        String rspStr = "";
        try {
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection connection = this.getFrontProxyConnection(factory);
            this.openConnection(connection);
            try (OutputStream os = this.getOutputStream(connection);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(connection);){
                    rspStr = this.recv(is);
                    this.closeOutputStreamQuietly(os);
                    this.closeInputStreamQuietly(is);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rspStr;
    }
}

