/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.service.balance;

import com.alibaba.fastjson.JSON;
import com.alipay.api.request.AlipayFundAccountQueryRequest;
import com.alipay.api.response.AlipayFundAccountQueryResponse;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.alipay.cmp.AlipayBusinessConfig;
import kd.ebg.aqap.banks.alipay.cmp.utils.AlipayRequestUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        AlipayFundAccountQueryResponse alipayFundAccountQueryResponse;
        this.logger.info("\u5f00\u59cb\u67e5\u8be2\u652f\u4ed8\u5b9d\u5f53\u65e5\u4f59\u989d");
        AlipayFundAccountQueryRequest alipayFundAccountQueryRequest = new AlipayFundAccountQueryRequest();
        BankAcnt acnt = request.getAcnt();
        String alipayPid = AlipayBusinessConfig.getPid(acnt.getAccNo());
        if (StrUtil.isEmpty((String)alipayPid)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u7b7e\u7ea6\u5e10\u53f7PID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728\u67e5\u8be2\u4e0e\u652f\u4ed8\u5e94\u7528\u94f6\u4f01\u8d26\u53f7\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        String accountType = "ACCTRANS_ACCOUNT";
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("alipay_user_id", alipayPid);
        param.put("account_type", "ACCTRANS_ACCOUNT");
        alipayFundAccountQueryRequest.setBizContent(JSON.toJSONString(param));
        this.logger.info("\u652f\u4ed8\u5b9d\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\uff1a" + alipayFundAccountQueryRequest.getBizContent());
        try {
            alipayFundAccountQueryResponse = (AlipayFundAccountQueryResponse)AlipayRequestUtil.execute(alipayFundAccountQueryRequest, acnt.getAccNo());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8c03\u7528\u652f\u4ed8\u5b9d\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        if (!alipayFundAccountQueryResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u652f\u4ed8\u5b9d\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), alipayFundAccountQueryResponse.getMsg(), alipayFundAccountQueryResponse.getSubCode(), alipayFundAccountQueryResponse.getSubMsg()));
        }
        BalanceInfo info = new BalanceInfo();
        String balance = alipayFundAccountQueryResponse.getAvailableAmount();
        if (StringUtils.isEmpty((String)balance)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u8fd4\u56de\u53ef\u7528\u4f59\u989d\u5b57\u6bb5\u4e3a\u7a7a!", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        info.setAvailableBalance(new BigDecimal(balance));
        info.setCurrentBalance(new BigDecimal(balance));
        info.setBalanceDateTime(LocalDateTime.now());
        info.setBankAcnt(request.getAcnt());
        info.setBankCurrency(request.getAcnt().getCurrency());
        this.logger.info("\u89e3\u6790\u5b8c\u6210\uff0c\u652f\u4ed8\u5b9d\u67e5\u8be2\u4f59\u989d\u6d41\u7a0b\u7ed3\u675f");
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{info}));
    }

    public String pack(BankBalanceRequest request) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]);
    }
}

