/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class GetStore {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetStore.class);
    private static UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);

    public static String getPRI() {
        return GetStore.getUserKey("private_key", ResManager.loadKDString((String)"\u7f51\u5173\u79c1\u94a5", (String)"GetStore_0", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
    }

    public static String getPUB() {
        return GetStore.getUserKey("public_key", ResManager.loadKDString((String)"\u7f51\u5173\u516c\u94a5", (String)"GetStore_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
    }

    public static String getSM() {
        return GetStore.getUserKey("sm_key", ResManager.loadKDString((String)"SM\u79d8\u94a5", (String)"GetStore_2", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
    }

    public static String getVI() {
        return GetStore.getUserKey("sm_vi", ResManager.loadKDString((String)"SM\u5411\u91cf", (String)"GetStore_3", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
    }

    public static String getUserKey(String key, String name) {
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\u79c1\u94a5\u6587\u4ef6\u3002", (String)"GetStore_4", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), name));
        }
        CipherInfo cipherInfo = GetStore.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetStore.getKey(fileContent);
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    public static String getBaseUrl() {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        if (StringUtils.isNotEmpty((String)port)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            port = "HTTPS".equals(protocol) && "443".equals(port) ? "" : ("HTTP".equals(protocol) && "80".equals(port) ? "" : ":" + port);
            return protocol + "://" + ip + port + RequestContextUtils.getBankParameterValue((String)"exchangeUri");
        }
        return ip;
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

