/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.dc.services.payment;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.aqap.banks.bbgb.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.bbgb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.bbgb.dc.services.utils.SecurityUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ebank-transfer/single_transfer/submitSingleTransfer.do");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String jsonString = Packer.packPay(paymentInfo).toJSONString();
        String sign = SecurityUtil.getInstance().getSign(jsonString);
        String encry = SecurityUtil.getInstance().getEncry(jsonString);
        JSONObject pay = new JSONObject();
        pay.put("signData", (Object)sign);
        pay.put("ciphertext", (Object)encry);
        pay.put("bankCertSN", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.bankPublicSN));
        return pay.toJSONString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject response = JSONObject.parseObject((String)s);
        String sys_code = response.getString("sys_code");
        String sys_msg = response.getString("sys_msg");
        if (!"0".equalsIgnoreCase(sys_code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), sys_code, sys_msg));
        }
        String data = response.getString("data");
        String decry = SecurityUtil.getInstance().getDecry(data);
        JSONObject payJson = JSONObject.parseObject((String)decry);
        String ec = payJson.getString("ec");
        String em = payJson.getString("em");
        if (!"0".equalsIgnoreCase(ec)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), ec, em));
        }
        JSONObject payData = payJson.getJSONObject("data");
        String orderState = payData.getString("orderState");
        String orderMessage = payData.getString("orderMessage");
        if ("02".equalsIgnoreCase(orderState) || "90".equalsIgnoreCase(orderState) || "95".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_2", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), (String)orderState, (String)orderMessage);
        } else if ("91".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayImpl_3", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), (String)orderState, (String)orderMessage);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_4", (String)"ebg-aqap-banks-bbgb-dc", (Object[])new Object[0]), (String)orderState, (String)orderMessage);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "submitSingleTransfer";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo info) {
        return true;
    }
}

