/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.ResponseCheck;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PayParser.class);

    public static EBBankPayResponse parsePay(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String payType = PayParser.getPayType(paymentInfo);
        Element NBCBEBankData = null;
        try {
            NBCBEBankData = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            ResponseCheck.checkPayResponse(NBCBEBankData, payType);
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"PayParser_14", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        try {
            Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
            Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
            String JYXH = DomHelper.getChildTextNotNull(opResult, "JYXH", ResManager.loadKDString((String)"\u7f51\u94f6\u4ea4\u6613\u5e8f\u53f7", (String)"PayParser_1", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String JYZT = DomHelper.getChildTextNotNull(opResult, "JYZT", ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"PayParser_2", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String YDDM = DomHelper.getChildTextNotNull(opResult, "YDDM", ResManager.loadKDString((String)"\u4ea4\u6613\u5e94\u7b54\u4ee3\u7801", (String)"PayParser_3", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String SBYY = DomHelper.getChildTextNullAsBlank(opResult, "SBYY");
            String FKYE = DomHelper.getChildTextNullAsBlank(opResult, "FKYE");
            String DZHD = DomHelper.getChildTextNullAsBlank(opResult, "DZHD");
            logger.info("\u7f51\u94f6\u4ea4\u6613\u5e8f\u53f7:" + JYXH);
            logger.info("\u4ea4\u6613\u72b6\u6001:" + JYZT);
            logger.info("\u4ea4\u6613\u5e94\u7b54\u4ee3\u7801:" + YDDM);
            logger.info("\u5931\u8d25\u539f\u56e0:" + SBYY);
            logger.info("\u4ed8\u6b3e\u8d26\u6237\u4f59\u989d:" + FKYE);
            logger.info("\u7535\u5b50\u56de\u5355\u53f7:" + DZHD);
            if (!"0000".equals(YDDM)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)YDDM, (String)SBYY);
                return new EBBankPayResponse(paymentInfos);
            }
            if ("90".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayParser_4", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else if ("91".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)JYZT, (String)SBYY);
            } else if ("99".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7cfb\u7edf\u5904\u7406\u4e2d", (String)"PayParser_5", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else if (!paymentInfo.is2SameBank() && "94".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406", (String)"PayParser_6", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)JYZT, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%1$s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988", (String)"PayParser_15", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[]{JYZT}), new Object[0]));
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"PayParser_16", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private static String getPayType(PaymentInfo paymentInfo) {
        if (paymentInfo.is2SameBank()) {
            return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26\u4e1a\u52a1", (String)"PayParser_10", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8de8\u884c\u6c47\u6b3e(\u540c\u57ce/\u5f02\u5730)\u4e1a\u52a1", (String)"PayParser_11", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
    }
}

