/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.Parser;
import kd.ebg.aqap.banks.psbc.dc.util.DomHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String balanceTransCode = this.getBalanceTransCode();
        Element root = Packer.createReqRootElement(balanceTransCode);
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u8d26\u6237\u5f53\u524d\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        if (!"00".equalsIgnoreCase(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        String Balance = Param.getChildTextTrim("Balance");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(request.getAcnt());
        balance.setBalanceDateTime(LocalDateTime.now());
        String Usable_Balance = Param.getChildTextTrim("Usable_Balance");
        if (StringUtils.isNotEmpty((String)Usable_Balance)) {
            balance.setAvailableBalance(BigDecimalHelper.div((String)Usable_Balance, (String)"100.00"));
        }
        this.setCurrentBalance(balance, Balance, 100);
        balance.setBankCurrency(request.getBankCurrency());
        balanceInfos.add(balance);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"1.7.1 \u8d26\u6237\u5f53\u524d\u4f59\u989d\u67e5\u8be2\uff081000\uff09", (String)"TodayBalanceImpl_8", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5f53\u524d\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }

    private String getBalanceTransCode() {
        boolean isVersion3 = BankBusinessConfig.isVersion3();
        if (isVersion3) {
            return "2000";
        }
        return "1000";
    }
}

