/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.payment.company.authorized;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.Parser;
import kd.ebg.aqap.banks.psbc.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.psbc.dc.util.DomHelper;
import kd.ebg.aqap.banks.psbc.dc.util.PackerUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedPayImpl
extends AbstractPayImpl
implements IPay {
    private static final Logger log = LoggerFactory.getLogger(AuthorizedPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u6307\u4ee4\uff081080/2080\uff09", (String)"AuthorizedPayImpl_0", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7f51\u94f6\u6388\u6743\u4ed8\u6b3e\u65b9\u5f0f\uff1a\u751f\u6210\u652f\u4ed8\u6307\u4ee4\uff081080/2080\uff09\u3002", (String)"AuthorizedPayImpl_1", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isPaymetByAuthorized();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String paymentTransCode = this.getPaymentTransCode();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u6307\u4ee4\uff08%s\uff09\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"AuthorizedPayImpl_15", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), paymentTransCode));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createReqRootElement(paymentTransCode);
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Pay_Account", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Rec_Name", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Param, (String)"Rec_Account", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Param, (String)"Rec_Bank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)Param, (String)"Rec_Bank_Id", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)Param, (String)"Amount", (String)PackerUtils.convertYuan2CentStr(paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Param, (String)"EnterpriseID", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)Param, (String)"VoucherID", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Area_Code", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Usage", (String)"");
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        String remark = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            remark = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)paymentInfo.getExplanation());
        } else {
            remark = paymentInfo.getExplanation();
        }
        JDomUtils.addChild((Element)Param, (String)"Remark", (String)PaymentUtil.substringChinese((boolean)needSubSummary, (String)remark, (int)40, (String)RequestContextUtils.getCharset()));
        JDomUtils.addChild((Element)Param, (String)"Same_Bank", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)Param, (String)"Same_City", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u8f6c\u8d26\u652f\u4ed8", (String)"AuthorizedPayImpl_4", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        if (!"00".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001\u3002", (String)"AuthorizedPayImpl_5", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u94f6\u884c\u54cd\u5e94\u7801\uff1a%1$s\u94f6\u884c\u54cd\u5e94\u6d88\u606f\uff1a%2$s\u3002", (String)"AuthorizedPayImpl_16", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        String Result = DomHelper.getChildTextNotNull(Param, "Result", ResManager.loadKDString((String)"\u63a5\u6536\u8f6c\u8d26\u6307\u4ee4\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_9", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        String Bank_Serial = DomHelper.getChildTextNullAsBlank(Param, "Bank_Serial");
        String Trans_Date = DomHelper.getChildTextNullAsBlank(Param, "Trans_Date");
        log.info("Bank_Serial(\u8f6c\u8d26\u94f6\u884c\u6d41\u6c34\u53f7):" + Bank_Serial);
        log.info("Trans_Date(\u8f6c\u8d26\u65e5\u671f):" + Trans_Date);
        if ("0".equalsIgnoreCase(Result)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u91d1\u878d\u670d\u52a1\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_10", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), (String)Result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u91d1\u878d\u670d\u52a1\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_10", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        } else if ("1".equalsIgnoreCase(Result)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u91d1\u878d\u670d\u52a1\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_11", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), (String)Result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u91d1\u878d\u670d\u52a1\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_11", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        } else if ("2".equalsIgnoreCase(Result)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4e0d\u786e\u5b9a\u94f6\u884c\u91d1\u878d\u670d\u52a1\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\u662f\u5426\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_12", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), (String)Result, (String)ResManager.loadKDString((String)"\u4e0d\u786e\u5b9a\u94f6\u884c\u91d1\u878d\u670d\u52a1\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587\u662f\u5426\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AuthorizedPayImpl_12", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988\u3002", (String)"AuthorizedPayImpl_17", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), Result), (String)"", (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988\u3002", (String)"AuthorizedPayImpl_17", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]), Result));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private String getPaymentTransCode() {
        boolean isVersion3 = BankBusinessConfig.isVersion3();
        if (isVersion3) {
            return "2080";
        }
        return "1080";
    }
}

