/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynhtb.dc.utils.file.YnhtbFileUtils;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class YnhtbPacker {
    public static Element packReqHead(String transCode, String seqId) {
        EBContext context = EBContext.getContext();
        Element root = JDomUtils.createRoot((String)"ReqHead");
        JDomUtils.addChild((Element)root, (String)"Version", (String)"1.0");
        JDomUtils.addChild((Element)root, (String)"TranCode", (String)transCode);
        JDomUtils.addChild((Element)root, (String)"TermDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"TermTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"SeqNo", (String)seqId);
        JDomUtils.addChild((Element)root, (String)"CorpId", (String)context.getParameter().getBankParameter("CorpId"));
        return root;
    }

    public static Element packRoot() {
        return JDomUtils.createRoot((String)"HTBankData");
    }

    public static String packBalance(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = YnhtbPacker.packRoot();
        Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
        Element header = YnhtbPacker.packReqHead("500001", Sequence.genSequence());
        JDomUtils.addChild((Element)reqData, (Element)header);
        Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packDetail(BankDetailRequest request) {
        Objects.requireNonNull(request.getStartDate(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YnhtbPacker_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        Objects.requireNonNull(request.getEndDate(), ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YnhtbPacker_1", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        String accNo = request.getAcnt().getAccNo();
        String startDate = request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Element root = YnhtbPacker.packRoot();
        Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
        Element header = YnhtbPacker.packReqHead("500002", Sequence.genSequence());
        JDomUtils.addChild((Element)reqData, (Element)header);
        Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)reqParam, (String)"BeginDate", (String)startDate);
        JDomUtils.addChild((Element)reqParam, (String)"EndDate", (String)endDate);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packSinglePay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos != null && !paymentInfos.isEmpty()) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            paymentInfo.setPayFinishDate(LocalDate.now());
            EBContext context = EBContext.getContext();
            String accNo = request.getAcnt().getAccNo();
            Element root = YnhtbPacker.packRoot();
            Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
            Element header = YnhtbPacker.packReqHead("510001", paymentInfo.getBankBatchSeqID());
            JDomUtils.addChild((Element)reqData, (Element)header);
            Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
            Boolean sameBank = paymentInfo.getSameBank();
            JDomUtils.addChild((Element)reqParam, (String)"TfrType", (String)(sameBank != false ? "0" : "1"));
            JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)reqParam, (String)"AcctName", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)reqParam, (String)"AcctNo1", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)reqParam, (String)"AcctName1", (String)paymentInfo.getIncomeAccName());
            if (!sameBank.booleanValue()) {
                JDomUtils.addChild((Element)reqParam, (String)"BranchNo1", (String)paymentInfo.getIncomeCnaps());
                JDomUtils.addChild((Element)reqParam, (String)"BranchName1", (String)paymentInfo.getIncomeBankName());
            }
            JDomUtils.addChild((Element)reqParam, (String)"Ccy", (String)paymentInfo.getIsoCurrencyCode());
            JDomUtils.addChild((Element)reqParam, (String)"Amount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)reqParam, (String)"CustType", (String)(paymentInfo.getIndividual() != false ? "0" : "1"));
            JDomUtils.addChild((Element)reqParam, (String)"CertNo", (String)paymentInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)reqParam, (String)"Memo", (String)paymentInfo.getExplanation());
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        throw new EBServiceException(ResManager.loadKDString((String)"\u6ca1\u6709paymentInfo", (String)"YnhtbPacker_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
    }

    public static String packQuerySinglePay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos != null && !paymentInfos.isEmpty()) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            EBContext context = EBContext.getContext();
            String accNo = request.getAcnt().getAccNo();
            String seqId = paymentInfo.getBankBatchSeqID();
            String date = paymentInfo.getPayFinishDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            Element root = YnhtbPacker.packRoot();
            Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
            Element header = YnhtbPacker.packReqHead("510002", Sequence.genSequence());
            JDomUtils.addChild((Element)reqData, (Element)header);
            Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
            JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
            JDomUtils.addChild((Element)reqParam, (String)"OldTermDate", (String)date);
            JDomUtils.addChild((Element)reqParam, (String)"OldSeqNo", (String)seqId);
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        throw new EBServiceException(ResManager.loadKDString((String)"\u6ca1\u6709paymentInfo", (String)"YnhtbPacker_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
    }

    public static String packBatchPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos != null && !paymentInfos.isEmpty()) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            EBContext context = EBContext.getContext();
            String accNo = request.getAcnt().getAccNo();
            String accName = request.getAcnt().getAccName();
            Element root = YnhtbPacker.packRoot();
            Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
            Element header = YnhtbPacker.packReqHead("510003", paymentInfo.getBankBatchSeqID());
            JDomUtils.addChild((Element)reqData, (Element)header);
            Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
            YnhtbFileUtils ynhtbFileUtils = new YnhtbFileUtils();
            StringBuilder sb = new StringBuilder();
            sb.append(paymentInfo.getBankBatchSeqID()).append('_').append(paymentInfo.getInsertTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append('_').append(accNo).append("_Batch_Req.txt");
            String fileName = sb.toString();
            String fileContent = ynhtbFileUtils.packBatchPayUploadFileContent(paymentInfos);
            ynhtbFileUtils.uploadFileToSftp(fileName, fileContent);
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (PaymentInfo info : paymentInfos) {
                totalAmount = totalAmount.add(info.getAmount());
            }
            JDomUtils.addChild((Element)reqParam, (String)"TotalNum", (String)(paymentInfos.size() + ""));
            JDomUtils.addChild((Element)reqParam, (String)"TotalAmt", (String)totalAmount.toString());
            JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
            JDomUtils.addChild((Element)reqParam, (String)"AcctName", (String)accName);
            JDomUtils.addChild((Element)reqParam, (String)"FileName", (String)fileName);
            JDomUtils.addChild((Element)reqParam, (String)"CertNo", (String)paymentInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)reqParam, (String)"Memo", (String)paymentInfo.getExplanation());
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        throw new EBServiceException(ResManager.loadKDString((String)"\u6ca1\u6709paymentInfo", (String)"YnhtbPacker_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
    }

    public static String packQueryBatchPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos != null && !paymentInfos.isEmpty()) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            String accNo = request.getAcnt().getAccNo();
            String date = paymentInfo.getInsertTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            Element root = YnhtbPacker.packRoot();
            Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
            Element header = YnhtbPacker.packReqHead("510004", Sequence.genSequence());
            JDomUtils.addChild((Element)reqData, (Element)header);
            Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
            JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
            JDomUtils.addChild((Element)reqParam, (String)"OldTermDate", (String)date);
            JDomUtils.addChild((Element)reqParam, (String)"OldSeqNo", (String)paymentInfo.getBankBatchSeqID());
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        throw new EBServiceException(ResManager.loadKDString((String)"\u6ca1\u6709paymentInfo", (String)"YnhtbPacker_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
    }

    public static String packSalaryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos != null && !paymentInfos.isEmpty()) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            EBContext context = EBContext.getContext();
            String accNo = request.getAcnt().getAccNo();
            String accName = request.getAcnt().getAccName();
            Element root = YnhtbPacker.packRoot();
            Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
            Element header = YnhtbPacker.packReqHead("510006", paymentInfo.getBankBatchSeqID());
            JDomUtils.addChild((Element)reqData, (Element)header);
            Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
            YnhtbFileUtils ynhtbFileUtils = new YnhtbFileUtils();
            StringBuilder sb = new StringBuilder();
            sb.append(paymentInfo.getBankBatchSeqID()).append('_').append(paymentInfo.getInsertTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append('_').append(accNo).append("_Salary_Req.txt");
            String fileName = sb.toString();
            String fileContent = ynhtbFileUtils.packBatchPayUploadFileContent(paymentInfos);
            ynhtbFileUtils.uploadFileToSftp(fileName, fileContent);
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (PaymentInfo info : paymentInfos) {
                totalAmount = totalAmount.add(info.getAmount());
            }
            JDomUtils.addChild((Element)reqParam, (String)"TotalNum", (String)(paymentInfos.size() + ""));
            JDomUtils.addChild((Element)reqParam, (String)"TotalAmt", (String)totalAmount.toString());
            JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
            JDomUtils.addChild((Element)reqParam, (String)"AcctName", (String)accName);
            JDomUtils.addChild((Element)reqParam, (String)"FileName", (String)fileName);
            JDomUtils.addChild((Element)reqParam, (String)"CertNo", (String)paymentInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)reqParam, (String)"Memo", (String)paymentInfo.getExplanation());
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        throw new EBServiceException(ResManager.loadKDString((String)"\u6ca1\u6709paymentInfo", (String)"YnhtbPacker_2", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
    }
}

