/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class CommonParser {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonParser.class);

    public static CCBHCBankResponse getFrontResponse(String rspStr) {
        CCBHCBankResponse response = new CCBHCBankResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element header = JDomUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomUtils.getChildText((Element)header, (String)"returnMsg");
        String exception = JDomUtils.getChildText((Element)header, (String)"exception");
        response.setResponseCode(returnCode);
        response.setResponseMessage(returnMsg);
        if (!"0000".equalsIgnoreCase(returnCode)) {
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5931\u8d25\u3002");
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
            Element body = JDomUtils.getChildElement((Element)root, (String)"body");
            String bankMsg = "";
            try {
                byte[] content = Base64.decodeBase64((String)JDomUtils.getChildText((Element)body, (String)"bankMsg"));
                bankMsg = new String(content, EBContext.getContext().getCharsetName());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u8282\u70b9bankMsg\u53d1\u751f\u5f02\u5e38\u3002", (String)"CommonParser_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
            }
            response.setBankMsg(bankMsg);
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u62a5\u6587\uff1a" + bankMsg);
        }
        return response;
    }

    public static CCBHCBankResponse getBankPreResponse(String rspStr) {
        CCBHCBankResponse response = new CCBHCBankResponse();
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String statusCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_TX_STATUS");
        String bankCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_CODE");
        String bankMsg = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        response.setResponseCode(bankCode);
        response.setResponseMessage(bankMsg);
        response.setBankMsg(bankMsg);
        if ("01".equalsIgnoreCase(statusCode)) {
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
        }
        Element tranResponse = JDomExtUtils.getChildElement((Element)header, (String)"tran_response");
        if (null != tranResponse) {
            String status = JDomExtUtils.getChildText((Element)tranResponse, (String)"status");
            String code = JDomExtUtils.getChildText((Element)tranResponse, (String)"code");
            if ("COMPLETE".equalsIgnoreCase(status)) {
                response.setPaySuccess(true);
            } else if ("FAIL".equals(status) && "YBLA058161B1".equals(code)) {
                logger.info("\u94f6\u884c\u8fd4\u56deYBLA058161B1\uff0c\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4");
                response.setSuccess(true);
            } else {
                response.setUnkown(true);
            }
        } else {
            response.setUnkown(true);
        }
        return response;
    }
}

