/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        if (PaymentUtils.isCaiziAcnt(request.getHeader().getAcnt().getAccNo())) {
            return this.packCaiziHisBalance(request);
        }
        return this.packNomalHisBalance(request);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        if (PaymentUtils.isCaiziAcnt(request.getHeader().getAcnt().getAccNo())) {
            return this.parseCaiziHisBalance(request, responseStr);
        }
        return this.parseNormalHisBalance(request, responseStr);
    }

    public EBBankBalanceResponse hisBalance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSERA6";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    /*
     * Exception decompiling
     */
    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String packNomalHisBalance(BankBalanceRequest rqst) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSERA6", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        JDomExtUtils.addChildCDData(request, "AccNo", rqst.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "StDt", rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(request, "EdDt", rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(request, "CcyCd", rqst.getHeader().getBankCurrency());
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public String packCaiziHisBalance(BankBalanceRequest rqst) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSERC4", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData(list1, "AccNo", rqst.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "CcyCd", rqst.getHeader().getBankCurrency());
        JDomExtUtils.addChildCDData(request, "Enqr_StDt", rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(request, "Enqr_CODt", rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankBalanceResponse parseCaiziHisBalance(BankBalanceRequest rqst, String rspStr) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String totalrec = JDomExtUtils.getChildText((Element)response, (String)"TOTAL_REC");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        if ("0".equalsIgnoreCase(totalrec)) {
            rsp.setBalances(new ArrayList(1));
            return rsp;
        }
        List list1 = response.getChildren("LIST1");
        ArrayList<BalanceInfo> hisBalanceInfos = new ArrayList<BalanceInfo>(16);
        for (Element node : list1) {
            String transDateStr = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
            String accNo = JDomExtUtils.getChildText((Element)node, (String)"AccNo");
            String accAvlBal = JDomExtUtils.getChildText((Element)node, (String)"Avl_Bal");
            String cshplBal = JDomExtUtils.getChildText((Element)node, (String)"CshPl_Bal");
            BalanceInfo info = new BalanceInfo();
            this.setBalanceDateTime(info, transDateStr + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            this.setCurrentBalance(info, cshplBal);
            this.setAvailableBalance(info, accAvlBal);
            this.setBankAcnt(info, rqst.getBankAcntList(), accNo);
            this.setBankCurrency(info, rqst.getHeader().getBankCurrency());
            hisBalanceInfos.add(info);
        }
        rsp.setBalances(hisBalanceInfos);
        return rsp;
    }

    public EBBankBalanceResponse parseNormalHisBalance(BankBalanceRequest rqst, String rspStr) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List list1 = response.getChildren("LIST1");
        LinkedList<BalanceInfo> hisBalanceInfos = new LinkedList<BalanceInfo>();
        String accNo = JDomExtUtils.getChildText((Element)response, (String)"AccNo");
        String currency = JDomExtUtils.getChildText((Element)response, (String)"CcyCd");
        for (Element node : list1) {
            String transDateStr = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
            String bal = JDomExtUtils.getChildText((Element)node, (String)"Bal");
            BalanceInfo info = new BalanceInfo();
            this.setBalanceDateTime(info, transDateStr + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            this.setAvailableBalance(info, bal);
            this.setCurrentBalance(info, bal);
            this.setBankAcnt(info, rqst.getBankAcntList(), accNo);
            this.setBankCurrency(info, rqst.getHeader().getBankCurrency(), currency);
            hisBalanceInfos.add(info);
        }
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        rsp.setBalances(hisBalanceInfos);
        return rsp;
    }
}

