/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail {
    public EBBankDetailResponse detail(BankDetailRequest request) {
        EBBankDetailResponse response = new EBBankDetailResponse();
        response.setDetails(new ArrayList(16));
        EBBankDetailResponse tempResponse = this.doBiz(request);
        while (!tempResponse.isLastPage() && tempResponse.getDetails().size() > 0) {
            response.getDetails().addAll(tempResponse.getDetails());
            request.setPageNum(tempResponse.getPageNum());
            tempResponse = this.doBiz(request);
        }
        response.getDetails().addAll(tempResponse.getDetails());
        return response;
    }

    public String pack(BankDetailRequest request) {
        if (PaymentUtils.isCaiziAcnt(request.getHeader().getAcnt().getAccNo())) {
            return TodayDetailImpl.packP1CMSERB4DetailStr(request);
        }
        return this.packDetailStr(request);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String rcrdNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        List detaiList = response.getChildren("LIST1");
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        if (!"0".equalsIgnoreCase(rcrdNum)) {
            for (Element node : detaiList) {
                String bal;
                String cdbankNm;
                String bankDetailSeqId;
                DetailInfo info = new DetailInfo();
                String txDt = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
                String txTm = JDomExtUtils.getChildText((Element)node, (String)"Txn_Tm");
                String detailNo = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dtl_No");
                String dbtCrDrcCd = JDomExtUtils.getChildText((Element)node, (String)"DbtCrDrcCd");
                if (StringUtils.isEmpty((String)txTm)) {
                    txTm = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
                }
                txTm = txDt + txTm;
                info.setTransDate(LocalDate.parse(txTm, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                info.setTransTime(LocalDateTime.parse(txTm, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                String dhamount = JDomExtUtils.getChildText((Element)node, (String)"DHAmt");
                if (!StringUtils.isEmpty((String)dhamount)) {
                    info.setDebitAmount(new BigDecimal(dhamount));
                }
                String cramount = JDomExtUtils.getChildText((Element)node, (String)"Cr_HpnAm");
                String ExoStm_Py_Rmrk = JDomExtUtils.getChildText((Element)node, (String)"ExoStm_Py_Rmrk");
                if (!StringUtils.isEmpty((String)cramount)) {
                    info.setCreditAmount(new BigDecimal(cramount));
                }
                info.setAccNo(request.getHeader().getAcnt().getAccNo());
                info.setAccName(request.getHeader().getAcnt().getAccName());
                String currency = JDomExtUtils.getChildText((Element)node, (String)"CcyCd");
                info.setCurrency(currency);
                String orAccNo = JDomExtUtils.getChildText((Element)node, (String)"CntprtAcc");
                info.setOppAccNo(orAccNo);
                String orAccName = JDomExtUtils.getChildText((Element)node, (String)"Cntrprt_AccNm");
                info.setOppAccName(orAccName);
                String bankSequnce = JDomExtUtils.getChildText((Element)node, (String)"CCBS_TxnSrlNo");
                String CstPty_Py_Jrnl_No = JDomExtUtils.getChildText((Element)node, (String)"CstPty_Py_Jrnl_No");
                if (!StringUtils.isEmpty((String)CstPty_Py_Jrnl_No) && CstPty_Py_Jrnl_No.startsWith("KD_")) {
                    bankDetailSeqId = CstPty_Py_Jrnl_No.substring("KD_".length());
                    info.setKdFlag(bankDetailSeqId);
                    info.setPayBankDetailSeqID(bankDetailSeqId);
                }
                if (!StringUtils.isEmpty((String)ExoStm_Py_Rmrk) && ExoStm_Py_Rmrk.startsWith("KD_")) {
                    bankDetailSeqId = ExoStm_Py_Rmrk.substring("KD_".length());
                    info.setKdFlag(bankDetailSeqId);
                    info.setPayBankDetailSeqID(bankDetailSeqId);
                }
                String Smy_Cd = JDomExtUtils.getChildText((Element)node, (String)"Smy_Cd");
                String Smy = JDomExtUtils.getChildText((Element)node, (String)"Smy");
                if ("0083".equalsIgnoreCase(Smy_Cd)) {
                    info.setKdFlag(null);
                    info.setPayBankDetailSeqID(null);
                }
                if (StringUtils.isEmpty((String)(cdbankNm = JDomExtUtils.getChildText((Element)node, (String)"CDBank_Nm")))) {
                    cdbankNm = JDomExtUtils.getChildText((Element)node, (String)"CADBank_Nm");
                }
                if (!StringUtils.isEmpty((String)cdbankNm)) {
                    info.setOppBankName(cdbankNm);
                }
                StringBuilder sortSb = new StringBuilder();
                sortSb.append(txDt).append("|").append(detailNo);
                info.setSortField(sortSb.toString());
                String remark = JDomExtUtils.getChildText((Element)node, (String)"Rmrk");
                if (StringUtils.isEmpty((String)remark)) {
                    info.setExplanation(Smy);
                } else {
                    info.setExplanation(remark);
                }
                if (remark.contains(PropertiesConstants.getValue((String)"COMPANY_PAY"))) {
                    info.setKdFlag(null);
                    info.setPayBankDetailSeqID(null);
                }
                if (StringUtils.isEmpty((String)(bal = JDomExtUtils.getChildText((Element)node, (String)"AcBa")))) {
                    bal = JDomExtUtils.getChildText((Element)node, (String)"Bal");
                }
                if (!StringUtils.isEmpty((String)bal)) {
                    info.setBalance(new BigDecimal(bal));
                }
                if ("0136".equalsIgnoreCase(Smy_Cd) && "#zdshanghua#".equalsIgnoreCase(ExoStm_Py_Rmrk) && "#zdshanghua#".equalsIgnoreCase(remark)) {
                    info.setTransType("autotransup");
                } else if ("0136".equalsIgnoreCase(Smy_Cd) && "#zdxiabo#".equalsIgnoreCase(ExoStm_Py_Rmrk) && "#zdxiabo#".equalsIgnoreCase(remark)) {
                    info.setTransType("autotransdown");
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(node);
                info.setJsonMap(jsonStr);
                info.setBankDetailNo(bankSequnce);
                String amount = "e";
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                if (!BankBusinessConfig.isPushWay(request.getHeader().getBankLoginID(), request.getHeader().getCustomerID())) {
                    if (info.getDebitAmount() != null && info.getDebitAmount().compareTo(new BigDecimal("0.00")) != 0) {
                        amount = info.getDebitAmount().toString();
                    } else if (info.getCreditAmount() != null && info.getCreditAmount().compareTo(new BigDecimal("0.00")) != 0) {
                        amount = info.getCreditAmount().toString();
                    }
                    jsonObject.put("Amount", (Object)amount);
                } else {
                    jsonObject.put("Amount", (Object)"e");
                }
                if (BankBusinessConfig.isUserNewApi(request.getHeader().getBankLoginID(), request.getHeader().getCustomerID())) {
                    jsonObject.put("cdFlag", (Object)dbtCrDrcCd);
                }
                info.setJsonMap(jsonObject.toJSONString());
                String accNo = request.getHeader().getAcnt().getAccNo();
                String transDate = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, info.getJsonMap());
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                result.add(info);
            }
        }
        String TOTAL_PAGE = header.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        if (request.getPageNum() >= total_page) {
            detailResponse.setLastPage(true);
        } else {
            detailResponse.setLastPage(false);
        }
        detailResponse.setPageNum(request.getPageNum() + 1);
        detailResponse.setDetails(result);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSER65,P1CMSERB4";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    /*
     * Exception decompiling
     */
    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String packDetailStr(BankDetailRequest rqst) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSER65", Sequence.genSequence(), "", String.valueOf(rqst.getPageNum()));
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        body.addContent((Content)request);
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData(list1, "AccNo", rqst.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "StDt", rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(request, "EdDt", rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public static String packP1CMSERB4DetailStr(BankDetailRequest rqst) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSERB4", Sequence.genSequence(), "", String.valueOf(rqst.getPageNum()));
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData(list1, "AccNo", rqst.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "Enqr_StDt", rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(request, "Enqr_CODt", rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(request, "CcyCd", rqst.getBankCurrency());
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public String genReceiptFileName(String dateStr, String detailNo, String bankSequnce) {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append(dateStr).append("-").append(detailNo).append("-").append(bankSequnce).append(".pdf");
        return sBuffer.toString();
    }

    public String genReceiptNewFileName(String accNo, String txDt, String bankSequnce, String amt, String trxNo, String dbtCrDrcCd) {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append(accNo).append("-").append(txDt).append("-").append(bankSequnce);
        if (!StringUtils.isEmpty((String)amt)) {
            sBuffer.append("-").append(amt);
        }
        sBuffer.append("-").append(trxNo);
        sBuffer.append("-").append(dbtCrDrcCd);
        sBuffer.append(".pdf");
        return sBuffer.toString();
    }
}

