/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.balance.HisBalancePacker;
import kd.ebg.aqap.banks.ccb.dc.services.balance.HisBalancePage;
import kd.ebg.aqap.banks.ccb.dc.services.balance.HisBalanceParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        return null;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "NW0100";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5916\u8054\u5e73\u53f0\u4f59\u989d\u67e5\u8be2(NW0100)", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return LocalDate.now().plusDays(-360L);
    }

    public boolean match(BankBalanceRequest request) {
        return !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) throws EBServiceException {
        CCB_DC_Packer.checkCurrency(rqst, false);
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(1);
        HisBalancePage hisBalancePage = new HisBalancePage();
        HisBalancePacker hisBalancePacker = new HisBalancePacker();
        HisBalanceParser hisBalanceParser = new HisBalanceParser();
        try {
            int pageTag = hisBalancePage.getFirstPageTag();
            String rspStr = null;
            do {
                EBContext.getContext().setProcessFlag(PROCESS_PACK);
                String rqstStr = hisBalancePacker.packHisBalance(rqst, pageTag);
                EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection conn = this.getConnection(factory);
                this.openConnection(conn);
                EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
                try (OutputStream os = this.getOutputStream(conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream(conn);){
                        rspStr = this.recv(is);
                        EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                        hisBalanceList.addAll(hisBalanceParser.parseHisBalance(rqst, rspStr));
                        pageTag = hisBalancePage.getNextPageTag(pageTag);
                    }
                }
            } while (!hisBalancePage.isLastPage(rspStr, pageTag));
            return new EBBankBalanceResponse(hisBalanceList);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

