/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.balance.HisBalanceImpl;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Element;

public class HisBalanceParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceParser.class);

    public List<BalanceInfo> parseHisBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(1);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element txInfo = root.getChild("TX_INFO");
        String accNo = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"ACC_NO");
        List detailInfos = txInfo.getChildren("DETAILINFO");
        if (null == detailInfos || 0 == detailInfos.size()) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u4f59\u989d[%1$s-%2$s]\u5931\u8d25,\u83b7\u5f97\u4f59\u989d\u7684BODY\u8282\u70b9\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u5f97\u4e0a\u65e5\u4f59\u989d\u4fe1\u606f:%3$s %4$s", (String)"HisBalanceParser_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")), rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")), response.getResponseCode(), response.getResponseMessage()));
            return hisBalanceList;
        }
        HisBalanceImpl hisBalance = new HisBalanceImpl();
        for (int i = 0; i < detailInfos.size(); ++i) {
            Element detailinfo = (Element)detailInfos.get(i);
            BalanceInfo balanceInfo = new BalanceInfo();
            hisBalanceList.add(balanceInfo);
            String balance = detailinfo.getChildText("BALANCE");
            String aval_balance = detailinfo.getChildText("AVAL_BALANCE");
            String date = detailinfo.getChildText("DATE");
            hisBalance.setBankAcnt(balanceInfo, rqst.getBankAcntList(), accNo);
            hisBalance.setBankCurrency(balanceInfo, rqst.getBankCurrency());
            hisBalance.setCurrentBalance(balanceInfo, balance);
            hisBalance.setAvailableBalance(balanceInfo, aval_balance);
            hisBalance.setBalanceDateTime(balanceInfo, date + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return hisBalanceList;
    }
}

