/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.company;

import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.payment.company.PayPacker;
import kd.ebg.aqap.banks.ccb.dc.services.payment.company.PayParser;
import kd.ebg.aqap.banks.ccb.dc.services.payment.company.QueryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "6W8010,6W8020";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_capital_allocation".equalsIgnoreCase(subBizType)) {
            paymentInfo.setIndividual(Boolean.valueOf(false));
            return true;
        }
        if ("pay".equalsIgnoreCase(subBizType)) {
            if (UseConvertor.isTransfer((PaymentInfo)paymentInfo)) {
                paymentInfo.setIndividual(Boolean.valueOf(false));
                return true;
            }
            if (!UseConvertor.isSalary((PaymentInfo)paymentInfo) && !UseConvertor.isTransfer((PaymentInfo)paymentInfo)) {
                if (paymentInfo.is2Individual()) {
                    if (BankBusinessConfig.isIndividualToCompany()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        return new PayPacker().packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new PayParser().parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private boolean isBatchSalaryPay(PaymentInfo paymentInfo) {
        boolean chooseBatch = false;
        try {
            chooseBatch = BankBusinessConfig.isBatchIndividualPay();
        }
        catch (EBServiceException eBServiceException) {
            // empty catch block
        }
        return paymentInfo.is2Merge() || chooseBatch;
    }
}

