/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.individual;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.payment.CCBUseConvertor;
import kd.ebg.aqap.banks.ccb.dc.services.payment.individual.PayPacker;
import kd.ebg.aqap.banks.ccb.dc.services.payment.individual.PayParser;
import kd.ebg.aqap.banks.ccb.dc.services.payment.individual.QueryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "6w1303";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u4ed8\u6b3e:\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613(6W1303\u4ea4\u6613)", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equalsIgnoreCase(subBizType) && !this.isBatchSalaryPay(paymentInfo) && !paymentInfo.is2Merge()) {
            CCBUseConvertor.transformUseCode4Individual(paymentInfo);
            paymentInfo.setIndividual(Boolean.valueOf(true));
            return true;
        }
        if ("pay".equalsIgnoreCase(subBizType)) {
            if (UseConvertor.isSalary((PaymentInfo)paymentInfo) && !this.isBatchSalaryPay(paymentInfo)) {
                CCBUseConvertor.transformUseCode4Individual(paymentInfo);
                paymentInfo.setIndividual(Boolean.valueOf(true));
                return true;
            }
            if (!(UseConvertor.isSalary((PaymentInfo)paymentInfo) || UseConvertor.isTransfer((PaymentInfo)paymentInfo) || !paymentInfo.is2Individual() || BankBusinessConfig.isIndividualToCompany() || BankBusinessConfig.isBatchIndividualPay())) {
                CCBUseConvertor.transformUseCode4Individual(paymentInfo);
                return true;
            }
        }
        return false;
    }

    public boolean isBatchSalaryPay(PaymentInfo paymentInfo) {
        boolean chooseBatch = false;
        try {
            chooseBatch = BankBusinessConfig.isBatchIndividualPay();
        }
        catch (EBServiceException eBServiceException) {
            // empty catch block
        }
        return paymentInfo.is2Merge() || chooseBatch;
    }

    public String pack(BankPayRequest request) {
        return new PayPacker().packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new PayParser().parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

