/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.smbcn.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.smbcn.dc.util.PackerCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        int differDays = (int)request.getStartDate().until(request.getEndDate(), ChronoUnit.MONTHS);
        if (differDays > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u8d77\u59cb\u65e5\u671f\u533a\u95f4\u4e0d\u80fd\u5927\u4e8e\u4e00\u4e2a\u6708\u3002", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]));
        }
        Element root = new Element("h2h");
        Element req = PackerCommon.getBaseElement(root, "h2h.001.002", request.getAcnt().getAccNo(), request.getBankCurrency());
        JDomUtils.addChild((Element)req, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)req, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element respInfo = JDomUtils.getChildElement((Element)root, (String)"respInfo");
        String acceptFlag = JDomUtils.getChildText((Element)respInfo, (String)"acceptFlag");
        String respCode = JDomUtils.getChildText((Element)respInfo, (String)"respCode");
        String respMsg = JDomUtils.getChildText((Element)respInfo, (String)"respMsg");
        if ("-1".equals(acceptFlag)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)respCode, (String)respMsg));
        }
        Element resp = JDomUtils.getChildElement((Element)root, (String)"resp");
        String statusFlag = JDomUtils.getChildText((Element)resp, (String)"statusFlag");
        respCode = JDomUtils.getChildText((Element)resp, (String)"respCode");
        respMsg = JDomUtils.getChildText((Element)resp, (String)"respMsg");
        if (!"1".equals(statusFlag)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)respCode, (String)respMsg));
        }
        List row = resp.getChildren("row");
        if (row == null || row.size() < 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u4f59\u989d\u63a5\u53e3\u672a\u8fd4\u56de\u8be5\u8d26\u53f7\u4f59\u989d\u4fe1\u606f\u3002", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]));
        }
        Element accPro = JDomUtils.getChildElement((Element)resp, (String)"accPro");
        String Account_num = JDomUtils.getChildText((Element)accPro, (String)"accNo");
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(16);
        for (Element element : row) {
            BalanceInfo balance = new BalanceInfo();
            String HisBalance = element.getChildTextTrim("balance");
            String availablBalance = element.getChildTextTrim("availablBalance");
            String balanceDate = element.getChildTextTrim("balanceDate");
            this.setBankAcnt(balance, request.getBankAcntList(), Account_num);
            this.setBankCurrency(balance, request.getBankCurrency());
            this.setCurrentBalance(balance, HisBalance);
            this.setAvailableBalance(balance, availablBalance);
            this.setBalanceDateTime(balance, balanceDate + "235959", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss"));
            resultList.add(balance);
        }
        return new EBBankBalanceResponse(resultList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "h2h.001.002";
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/corpfe/H2HService/SC_I";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
        super.configFactory(factory);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_5", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 30;
    }
}

