/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.web.dc.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.web.dc.detail.DetailPage;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    public static final String DETAIL_LINE_SEPARTOR = "|::|";
    public static final String DETAIL_END_TAG = "###END###";

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(100);
        String pageTag = DetailPage.getFirstPageTag(request);
        this.setCurrentPage(pageTag);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse ebBankDetailResponse = this.downloadDetail(request);
            this.logger.info("details\u7684\u6570\u91cf{}", (Object)ebBankDetailResponse.getDetails().size());
            if (ebBankDetailResponse == null || CollectionUtils.isEmpty((Collection)ebBankDetailResponse.getDetails())) continue;
            detailInfos.addAll(ebBankDetailResponse.getDetails());
        }
        this.logger.info("detailInfos\u7684\u6570\u91cf{}", (Object)detailInfos.size());
        return new EBBankDetailResponse(detailInfos);
    }

    /*
     * Exception decompiling
     */
    private EBBankDetailResponse downloadDetail(BankDetailRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append(bankDetailRequest.getAcnt().getAreaCode()).append("_accout_").append(this.getCurrentPage()).append(".txt");
        return sb.toString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        String[] lines;
        String pageTag = this.getCurrentPage();
        String nextPageTag = DetailPage.getNextPageTag(pageTag);
        this.setCurrentPage(nextPageTag);
        boolean lastPage = DetailPage.isLastPage(bankDetailRequest, pageTag);
        this.setLastPage(lastPage);
        if (StringUtils.isEmpty((String)rspStr)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        rspStr = rspStr.replace(DETAIL_END_TAG, "");
        for (String line : lines = StringUtils.split((String)rspStr, (String)"\n")) {
            String[] values = StringUtils.split((String)line, (String)DETAIL_LINE_SEPARTOR);
            if (values.length < 13) continue;
            DetailInfo info = new DetailInfo();
            String payAccNo = values[0];
            String amountStr = values[11];
            BigDecimal amount = new BigDecimal(amountStr);
            info.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            info.setAccName(bankDetailRequest.getAcnt().getAccName());
            info.setCurrency(bankDetailRequest.getBankCurrency());
            if (bankDetailRequest.getAcnt().getAccNo().equalsIgnoreCase(payAccNo)) {
                info.setDebitAmount(amount);
                info.setCreditAmount(ParserUtils.ZERO);
                info.setOppAccName(values[2]);
                info.setOppAccNo(values[3]);
            } else {
                info.setCreditAmount(amount);
                info.setDebitAmount(ParserUtils.ZERO);
                info.setOppAccName(values[0]);
                info.setOppAccNo(values[1]);
            }
            info.setOppBankName(values[4]);
            info.setExplanation(values[5]);
            DetailSysFiled.set((DetailInfo)info, (String)"bizRefNo", (String)values[12]);
            try {
                LocalDate transDate = LocalDate.parse(values[8], DateTimeFormatter.ofPattern("yyyyMMdd"));
                info.setTransDate(transDate);
                LocalDateTime actualTime = LocalDateTime.parse(values[8] + values[9], DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                info.setTransTime(actualTime);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u5f02\u5e38", (String)"DetailImpl_0", (String)"ebg-aqap-banks-web-dc", (Object[])new Object[0]), (Throwable)e);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transNo", (Object)values[12]);
            jsonObject.put("amount", (Object)amountStr);
            jsonObject.put("transDate", (Object)values[8]);
            info.setJsonMap(jsonObject.toString());
            info.setBankDetailNo(values[12]);
            result.add(info);
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "query";
    }

    public String getBizDesc() {
        return null;
    }
}

