/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdcb.cms.service.payment.sameBank;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdcb.cms.utils.Packer;
import kd.ebg.aqap.banks.cdcb.cms.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element ap = Packer.creatHead("03020104A0239", Sequence.gen18Sequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"reqDate", (String)LocalDateUtil.formatDate((LocalDateTime)paymentInfo.getSubmitSuccessTime()));
        JDomUtils.addChild((Element)body, (String)"reqSerialNo", (String)paymentInfo.getBankBatchSeqId());
        String request = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Packer.createCommonMsg(request);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element element = Parser.getResponseElement(rspStr);
        Element head = element.getChild("head");
        Element body = element.getChild("body");
        BankResponse bankResponse = Parser.parseBankResponse(head);
        if ("0_0000".equals(bankResponse.getResponseCode())) {
            String busiStat = body.getChildText("busiStat");
            String jnlStat = body.getChildText("jnlStat");
            String jnlMsg = body.getChildText("jnlMsg");
            if ("N".equals(jnlStat) || "F".equals(jnlStat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else if ("F".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)busiStat, (String)jnlMsg);
            } else if ("S".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)busiStat, (String)jnlMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)busiStat, (String)jnlMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020104A0239";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u67e5\u8bc1", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]);
    }
}

