/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.bank;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.ebg.aqap.formplugin.plugin.common.EBSITListPlugin;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.framework.bank.api.IBankServiceDesc;

public class BankInterfacePlugin
extends AbstractFormPlugin
implements ClickListener {
    public void afterBindData(EventObject e) {
        this.updateNumber();
        String tenantID = RequestContext.get().getTenantId();
        boolean isHide = EBSITListPlugin.TENANT_LIST.contains(tenantID);
        this.getView().setVisible(Boolean.valueOf(isHide), new String[]{"bar_save", "bar_submit", "bar_audit", "check"});
    }

    public void registerListener(EventObject e) {
        Button btn = (Button)this.getControl("check");
        btn.addClickListener((ClickListener)this);
    }

    private void updateNumber() {
        if (StringUtils.isEmpty((String)this.getModel().getValue("number"))) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
            String bankVersion = basedataEdit.getModel().getDataEntity().getString("group.number");
            String number = bankVersion + "_" + ID.genStringId();
            this.getModel().setValue("number", (Object)number);
            this.getView().updateView("number");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            String className = (String)this.getModel().getValue("class_name");
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LocaleString localeString = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3010\u63a5\u53e3\u5b9e\u73b0\u7c7b\u540d\u3011\u53c2\u6570\u503c\u3002", (String)"BankInterfacePlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), className));
                this.getView().showTipNotification(localeString.getLocaleValue());
                args.setCancel(true);
            }
        }
    }

    public void click(EventObject event) {
        block5: {
            String className = (String)this.getModel().getValue("class_name");
            try {
                Class<?> bankServiceDesc = Class.forName(className);
                if (className.startsWith("kd.ebg.aqap")) {
                    this.check4AQAP(bankServiceDesc);
                    break block5;
                }
                if (className.startsWith("kd.ebg.receipt")) {
                    this.getView().showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u56de\u5355\u5e94\u7528\u7684\u7c7b\u6682\u4e0d\u652f\u6301\u68c0\u6d4b\u3002", (String)"BankInterfacePlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).getLocaleValue());
                    break block5;
                }
                if (className.startsWith("kd.ebg.note")) {
                    this.getView().showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u7535\u7968\u5e94\u7528\u7684\u7c7b\u6682\u4e0d\u652f\u6301\u68c0\u6d4b\u3002", (String)"BankInterfacePlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).getLocaleValue());
                    break block5;
                }
                LocaleString localeString = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u8f93\u5165\u6709\u8bef\uff0c\u4e0d\u5c5e\u4e8e\u94f6\u4f01\u4e91\u5e94\u7528\u3002", (String)"BankInterfacePlugin_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), className));
                this.getView().showTipNotification(localeString.getLocaleValue());
                return;
            }
            catch (ClassNotFoundException e) {
                LocaleString localeString = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3010\u63a5\u53e3\u5b9e\u73b0\u7c7b\u540d\u3011\u53c2\u6570\u503c\u3002", (String)"BankInterfacePlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), className));
                this.getView().showTipNotification(localeString.getLocaleValue());
            }
        }
    }

    private void check4AQAP(Class<?> bankServiceDesc) {
        try {
            IBankServiceDesc bankService = (IBankServiceDesc)bankServiceDesc.newInstance();
            String bankCode = bankService.getBizCode();
            String name = bankService.getBizDesc();
            this.updateView(name, bankCode);
            this.getView().showSuccessNotification(new LocaleString(ResManager.loadKDString((String)"\u68c0\u6d4b\u901a\u8fc7\u3002", (String)"BankInterfacePlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).getLocaleValue());
        }
        catch (IllegalAccessException bankService) {
        }
        catch (InstantiationException bankService) {
        }
        catch (ClassCastException e) {
            this.getView().showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u7c7b\u4e0d\u662f\u6807\u51c6\u4e1a\u52a1\u63a5\u53e3\u5b9e\u73b0\u7c7b\u3002", (String)"BankInterfacePlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).getLocaleValue());
        }
    }

    private void updateView(String name, String bankCode) {
        if (StringUtil.isNotNil(name)) {
            this.getModel().setValue("name", (Object)name);
            this.getView().updateView("name");
        }
        if (StringUtil.isNotNil(bankCode)) {
            this.getModel().setValue("bank_code", (Object)bankCode);
            this.getView().updateView("bank_code");
        }
    }
}

