/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.banklogin;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.model.testnet.Response;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.repository.EbcBankLoginRepository;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.net.TestConnect;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRelRepository;

public class BankLoginListPlugin
extends EbcAddBankListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY = "aqap_bank_login_config";
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private EbcBankLoginRepository ebcBankLoginRepository = (EbcBankLoginRepository)SpringContextUtil.getBean(EbcBankLoginRepository.class);
    private BankLoginConfigRepository bankLoginConfigRepository = (BankLoginConfigRepository)SpringContextUtil.getBean(BankLoginConfigRepository.class);
    private BankLoginRelRepository bankLoginRelRepository = (BankLoginRelRepository)SpringContextUtil.getBean(BankLoginRelRepository.class);
    private CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void setFilter(SetFilterEvent e) {
        TreeView treeView;
        Long bankVersionId;
        super.setFilter(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        boolean flag = false;
        String isFromBankList = this.getView().getPageCache().get("isFromPage");
        if (!CollectionUtils.isEmpty((Map)paramMap) && e.getQFilters().size() == 0 && !Objects.equals(isFromBankList, "isFromBankList") && (bankVersionId = (Long)paramMap.get("bankVersionId")) != null) {
            e.getQFilters().add(new QFilter("group", "=", (Object)bankVersionId));
            this.getView().getPageCache().put("isFromPage", "isFromBankList");
            flag = true;
            if (bankVersionId == 1715068818406500000L) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap1"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap1"});
            }
        }
        e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        QFilter isYxc = new QFilter("custom_id", "like", (Object)"JDY%");
        QFilter isJdy = new QFilter("custom_id", "like", (Object)"YKJ%");
        QFilter isKis = new QFilter("custom_id", "like", (Object)"PRO%");
        e.getQFilters().add(new QFilter("custom_id", "=", (Object)RequestContext.get().getTenantId()).or(isYxc).or(isJdy).or(isKis));
        if (!flag && (treeView = (TreeView)this.getView().getControl("treeview")) != null) {
            Map focusNode = treeView.getTreeState().getFocusNode();
            if (focusNode == null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap1"});
            } else {
                String text = (String)focusNode.get("id");
                if ("1715068818406500000".equals(text)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap1"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap1"});
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)formOperate.getOperateKey())) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            String text = (String)focusNode.get("text");
            if (!ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankLoginListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equalsIgnoreCase(text)) return;
            this.getView().showTipNotification(MultiLang.getSelectBankTip());
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"logic_delete", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection == null) return;
            if (listSelectedRowCollection.size() <= 0) return;
            listSelectedRowCollection.forEach(selectedRow -> {
                String bankLogin = selectedRow.getNumber();
                if (this.ebcBankAcntRepository.exitsAcntByBankLogin(bankLogin)) {
                    this.getView().showTipNotification(MultiLang.getDeleteBankAcntTip(bankLogin));
                    args.setCancel(true);
                    return;
                }
                DynamicObject bankLoginRel = this.bankLoginRelRepository.findByMasterNumber(bankLogin);
                if (bankLoginRel != null) {
                    String exclusive_number = bankLoginRel.getString("exclusive_number");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u524d\u7f6e\u673a%s\u3002", (String)"BankLoginListPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin) + String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u5f53\u524d\u524d\u7f6e\u673a\u88ab\u4e13\u5c5e\u524d\u7f6e\u673a%s\u3002", (String)"BankLoginListPlugin_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), exclusive_number) + String.format(ResManager.loadKDString((String)"\u6240\u5173\u8054\uff0c\u8bf7\u5148\u5230%s\u7684\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u3010\u6240\u5c5e\u4e3b\u524d\u7f6e\u673a\u7f16\u53f7\u3011\u9009\u62e9\u5176\u4ed6\u4e3b\u524d\u7f6e\u673a\uff0c\u53d6\u6d88\u5173\u8054\u5173\u7cfb\u3002", (String)"BankLoginListPlugin_11", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), exclusive_number));
                    args.setCancel(true);
                    return;
                }
                DynamicObject dynamicObject = this.ebcBankLoginRepository.getBankLoginByBankLoginID(bankLogin);
                if (dynamicObject != null && "1".equalsIgnoreCase(dynamicObject.getString("enable"))) {
                    dynamicObject.set("enable", (Object)"0");
                    TXHandle h = TX.requiresNew();
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                        this.bankLoginConfigRepository.deleteByBankLoginIDAndCustomID(bankLogin, RequestContext.get().getTenantId());
                        this.bankLoginRelRepository.deleteByExclusiveNumber(bankLogin);
                        this.certRepository.delete(bankLogin, RequestContext.get().getTenantId());
                    }
                    catch (Exception ex) {
                        h.markRollback();
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u5220\u9664\u51fa\u73b0\u5f02\u5e38", (String)"BankLoginListPlugin_15", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)ex);
                    }
                    finally {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u524d\u7f6e\u673a%s\u5931\u8d25\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BankLoginListPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin));
                args.setCancel(true);
                return;
            });
            this.getView().invokeOperation("refresh");
            return;
        }
        if (StringUtils.equals((CharSequence)"test_telnet", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection == null) return;
            if (listSelectedRowCollection.size() <= 0) return;
            String customID = RequestContext.get().getTenantId();
            listSelectedRowCollection.forEach(selectedRow -> {
                String bankLogin = selectedRow.getNumber();
                DynamicObject ip = this.bankLoginConfigRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLogin, customID, "ip");
                DynamicObject port = this.bankLoginConfigRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLogin, customID, "exchangePort");
                DynamicObject fpPort = this.bankLoginConfigRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLogin, customID, "frontProxy_Port");
                DynamicObject fpIP = this.bankLoginConfigRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLogin, customID, "front_proxy_ip");
                DynamicObject signPort = this.bankLoginConfigRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLogin, customID, "signPort");
                if (bankLogin.contains("EBG_SIM")) {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"BankLoginListPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin));
                    return;
                }
                if (ip == null || StringUtil.isNullOrEmpty(ip.getString("bank_config_value"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c%s\u672a\u914d\u7f6eIP\u3002", (String)"BankLoginListPlugin_13", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin));
                    return;
                }
                try {
                    String value;
                    if (port == null || StringUtil.isNullOrEmpty(port.getString("bank_config_value"))) {
                        URL url = new URL(ip.getString("bank_config_value"));
                        int p = url.getPort();
                        if (p == -1) {
                            p = url.getDefaultPort();
                        }
                        if (port == null) {
                            port = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY);
                        }
                        port.set("bank_config_value", (Object)String.valueOf(p));
                        ip.set("bank_config_value", (Object)url.getHost());
                    }
                    HashMap<String, Integer> portMap = new HashMap<String, Integer>(4);
                    HashMap<String, String> ipMap = new HashMap<String, String>(2);
                    ArrayList<String> errMsgList = new ArrayList<String>(4);
                    String errMsgFormat = ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c%s\u914d\u7f6e\u6709\u8bef\u3002", (String)"BankLoginListPlugin_21", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
                    if (fpPort != null) {
                        value = fpPort.getString("bank_config_value");
                        if (!this.checkLegal(value)) {
                            errMsgList.add(ResManager.loadKDString((String)"\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\u53f7", (String)"BankLoginFormPlugin_39", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                        } else {
                            portMap.put("frontProxy_Port", Integer.parseInt(value));
                        }
                        if (fpIP != null) {
                            ipMap.put("front_proxy_ip", fpIP.getString("bank_config_value"));
                        }
                    }
                    if (signPort != null) {
                        value = signPort.getString("bank_config_value");
                        if (!this.checkLegal(value)) {
                            errMsgList.add(ResManager.loadKDString((String)"\u7b7e\u540d\u7aef\u53e3\u53f7", (String)"BankLoginFormPlugin_38", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                        } else {
                            portMap.put("signPort", Integer.parseInt(value));
                        }
                    }
                    if (!errMsgList.isEmpty()) {
                        this.getView().showErrorNotification(String.format(errMsgFormat, String.join((CharSequence)"\u3001", errMsgList)));
                        return;
                    }
                    TestConnect testConnect = TestConnect.getInstance();
                    Response response = testConnect.test(customID, bankLogin, ip.getString("bank_config_value"), port.getInt("bank_config_value"), portMap, ipMap);
                    if (response.isSuccess()) {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"BankLoginListPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankLogin));
                    } else {
                        String errMsg = response.getErrMsg();
                        this.getView().showErrorNotification(errMsg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.getView().showTipNotification(MultiLang.getCheckLinkErrorTip(bankLogin));
                }
            });
            return;
        }
        if (StringUtils.equals((CharSequence)"open_same_banktab", (CharSequence)formOperate.getOperateKey())) {
            String bankVersionIdString;
            block10: {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Map paramMap = formShowParameter.getCustomParams();
                TreeView treeView = (TreeView)this.getView().getControl("treeview");
                Map focusNode = treeView.getTreeState().getFocusNode();
                String text = (String)focusNode.get("text");
                if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankLoginListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equals(text)) {
                    if (!CollectionUtils.isEmpty((Map)paramMap) && paramMap.containsKey("bankVersionId")) {
                        Long bankVersionId = (Long)paramMap.get("bankVersionId");
                        bankVersionIdString = bankVersionId.toString();
                        break block10;
                    } else {
                        this.getView().showTipNotification(MultiLang.getSelectBankTip());
                        args.setCancel(true);
                        return;
                    }
                }
                bankVersionIdString = (String)focusNode.get("id");
            }
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
            customParams.put("bankVersionId", bankVersionIdString);
            this.showListPage("aqap_bank_same_word_bill", customParams);
            return;
        }
        if (!StringUtils.equals((CharSequence)"open_cbs_banktab", (CharSequence)formOperate.getOperateKey())) return;
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        Map focusNode = treeView.getTreeState().getFocusNode();
        String text = (String)focusNode.get("text");
        if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankLoginListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equals(text)) {
            this.getView().showTipNotification(MultiLang.getSelectBankTip());
            args.setCancel(true);
            return;
        }
        String id = (String)focusNode.get("id");
        if (!"1715068818406500000".equals(id)) {
            this.getView().showTipNotification(MultiLang.getCBSBankTip());
            args.setCancel(true);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillFormId("aqap_bank_cbs_word_bill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void showListPage(String formId, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        if (!CollectionUtils.isEmpty(customParams)) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public boolean checkLegal(String port) {
        try {
            int v = Integer.parseInt(port);
            return v >= 0 && v <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

