/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.baseplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.CompareEnum;
import kd.ebg.aqap.formplugin.plugin.util.InitComboItemUtil;
import kd.ebg.aqap.formplugin.util.CosmicDateUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;

public class EBGBasePlugin
extends AbstractListPlugin {
    private static final String ENTITY_KEY_BANK_ACNT = "aqap_bank_acnt";
    public FilterContainerInitArgs initArgs;

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        ControlFilters controlFilters = view.getControlFilters();
        List bankVersionIds = controlFilters.getFilter("bank_version.id");
        if ("bank_acnt.id".equalsIgnoreCase(fieldName)) {
            args.getQfilters().clear();
            args.getQfilters().add(new QFilter("enable", "=", (Object)"1"));
            args.getQfilters().add(new QFilter("status", "=", (Object)"A"));
            if (bankVersionIds.size() > 0 && !"".equals(bankVersionIds.get(0))) {
                args.getQfilters().add(new QFilter("group", "=", (Object)Long.parseLong(String.valueOf(bankVersionIds.get(0)))));
            }
        } else if ("bank_currency.id".equalsIgnoreCase(fieldName)) {
            args.getQfilters().clear();
            String bankVersionID = this.getPageCache().get("belongBankVersionId");
            if (!StringUtil.isNullOrEmpty(bankVersionID)) {
                args.getQfilters().add(new QFilter("bank_version", "=", (Object)Long.parseLong(bankVersionID)));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String bankCurrency;
        String acntId;
        String bankVersionId = String.valueOf(args.getFilterValue("bank_version.id"));
        if ("null".equalsIgnoreCase(bankVersionId)) {
            bankVersionId = "";
        }
        if ("null".equalsIgnoreCase(acntId = String.valueOf(args.getFilterValue("bank_acnt.id")))) {
            acntId = "";
        }
        if ("null".equalsIgnoreCase(bankCurrency = String.valueOf(args.getFilterValue("bank_currency.id")))) {
            bankCurrency = "";
        }
        String startDateTime = "";
        String endDateTime = "";
        Object object = args.getFilterValue("trans_date");
        if (object instanceof List) {
            List list = (List)object;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (list.size() == 2) {
                    startDateTime = CosmicDateUtil.timeTranslate(sdf.parse((String)list.get(0) + " 00:00:00"));
                    endDateTime = CosmicDateUtil.timeTranslate(sdf.parse((String)list.get(1) + " 00:00:00"));
                } else if (list.size() == 1) {
                    startDateTime = CosmicDateUtil.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getStartDate()));
                    endDateTime = CosmicDateUtil.timeTranslateBeforeDay(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getEndDate()));
                }
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"EBGBasePlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
        boolean isBankVersionChanaged = !bankVersionId.equalsIgnoreCase(this.getPageCache().get("selectedBankId")) && (!"".equalsIgnoreCase(bankVersionId) || this.getPageCache().get("selectedBankId") != null);
        boolean isAcntChanaged = !acntId.equalsIgnoreCase(this.getPageCache().get("selectedAcntId")) && (!"".equalsIgnoreCase(acntId) || this.getPageCache().get("selectedAcntId") != null);
        this.getPageCache().put("selectedBankId", bankVersionId);
        this.getPageCache().put("selectedAcntId", acntId);
        this.getPageCache().put("bankCurrency", bankCurrency);
        this.getPageCache().put("startDateTime", startDateTime);
        this.getPageCache().put("endDateTime", endDateTime);
        if (StringUtils.isNotBlank((CharSequence)bankVersionId)) {
            DynamicObject bankVersion = ((BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class)).loadDynamicObjectByID(Long.valueOf(bankVersionId));
            this.getPageCache().put("bank_version", bankVersion.getString("number"));
        } else {
            this.getPageCache().put("bank_version", "");
        }
        this.filterContainerInit(this.initArgs);
        this.cacheCommonFilter(args.getSearchClickEvent(), isBankVersionChanaged, isAcntChanaged);
    }

    private void cacheCommonFilter(SearchClickEvent searchClickEvent, boolean isBankVersionChanaged, boolean isAcntChanaged) {
        List customfilter;
        if (searchClickEvent.getFilterValues() != null && (customfilter = (List)searchClickEvent.getFilterValues().get("customfilter")) != null) {
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                if (isBankVersionChanaged && fieldName.startsWith("bank_acnt")) {
                    this.commonFilterChange(filteritem, "");
                    this.getPageCache().remove("selectedAcntId");
                    continue;
                }
                if (isBankVersionChanaged && fieldName.startsWith("bank_currency")) {
                    this.commonFilterChange(filteritem, "");
                    this.getPageCache().remove("bankCurrency");
                    continue;
                }
                if (!isAcntChanaged || !fieldName.startsWith("bank_currency")) continue;
                String acntId = this.getPageCache().get("selectedAcntId");
                String bankCurrency = this.getPageCache().get("defualtBankCurrency");
                if (StringUtil.isNullOrEmpty(acntId)) {
                    bankCurrency = "";
                }
                this.commonFilterChange(filteritem, bankCurrency);
                this.getPageCache().put("bankCurrency", bankCurrency);
            }
        }
    }

    protected void commonFilterChange(Map<String, List<Object>> commonFilter, String val) {
        if (commonFilter != null) {
            ArrayList<String> commonList = new ArrayList<String>(16);
            if (StringUtil.isNullOrEmpty(val)) {
                commonList.add("");
            } else {
                commonList.add(val);
            }
            commonFilter.put("Value", commonList);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List currencyItems;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equalsIgnoreCase("bank_version.name")) {
                List<ComboItem> bankItems = new InitComboItemUtil().initBankVersionList();
                currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(bankItems);
                continue;
            }
            if (fieldName.equalsIgnoreCase("bank_acnt.number")) {
                List<ComboItem> acctItems = this.initAcctItemsList();
                currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(acctItems);
                continue;
            }
            if (!fieldName.equalsIgnoreCase("bank_currency.name")) continue;
            List<ComboItem> items = this.initCurrItemsList();
            currencyItems = commonFilterColumn.getComboItems();
            currencyItems.clear();
            commonFilterColumn.setComboItems(items);
        }
    }

    protected List<ComboItem> initAcctItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(16);
        String selectProperties = "id, number, name";
        QFilter[] qfilters = StringUtil.isNotNil(this.getPageCache().get("selectedBankId")) ? new QFilter[]{QFilter.of((String)"group.id=? and enable=?", (Object[])new Object[]{Long.parseLong(this.getPageCache().get("selectedBankId")), "1"})} : new QFilter[]{QFilter.of((String)"enable=?", (Object[])new Object[]{"1"})};
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_ACNT, (String)selectProperties, (QFilter[])qfilters);
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject cashAcct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("number")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<ComboItem> initCurrItemsList() {
        String bankVersionId;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String defualtCurrency = "";
        if (StringUtil.isNotNil(this.getPageCache().get("selectedAcntId"))) {
            String acntId = this.getPageCache().get("selectedAcntId");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_KEY_BANK_ACNT, (String)"id, group.id, number, currency.number", (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{Long.parseLong(acntId)})});
            if (dynamicObject == null) {
                this.getPageCache().remove("belongBankVersionId");
                return items;
            }
            bankVersionId = dynamicObject.getString("group.id");
            this.getPageCache().put("belongBankVersionId", bankVersionId);
            defualtCurrency = dynamicObject.getString("currency.number");
        } else {
            if (!StringUtil.isNotNil(this.getPageCache().get("selectedBankId"))) {
                this.getPageCache().remove("belongBankVersionId");
                return items;
            }
            bankVersionId = this.getPageCache().get("selectedBankId");
            this.getPageCache().put("belongBankVersionId", bankVersionId);
        }
        String selectProperties = "id, number, name";
        QFilter[] qfilters = new QFilter[]{QFilter.of((String)"bank_version.id=?", (Object[])new Object[]{Long.valueOf(bankVersionId)})};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bank_currency", (String)selectProperties, (QFilter[])qfilters);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject cashAcct = dynamicObjects[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("name")));
                item.setValue(cashAcct.getString("id"));
                items.add(item);
                if (!StringUtil.isNotNil(defualtCurrency) || !defualtCurrency.equalsIgnoreCase(cashAcct.getString("number"))) continue;
                this.getPageCache().put("defualtBankCurrency", cashAcct.getString("id"));
            }
        }
        return items;
    }
}

