/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.detail;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.detail.utils.DetailConvert;
import kd.ebg.aqap.common.entity.biz.detail.Detail;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponse;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponseBody;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.repository.DetailInfoRepository;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.EBGBasePlugin;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.service.biz.BizService;
import kd.ebg.aqap.formplugin.util.LocalDateUtils;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.currency.BankCurrencyRepository;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class BankAcntDetailListPlugin
extends EBGBasePlugin {
    private static final String ENTITY_KEY_BANK_ACNT_DETAIL = "aqap_bank_acnt_detail";
    private BizService bizService = (BizService)SpringContextUtil.getBean(BizService.class);
    private EbcBankAcntRepository bankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private BankCurrencyRepository currencyRepository = (BankCurrencyRepository)SpringContextUtil.getBean(BankCurrencyRepository.class);
    private ObjectPropertiesRepository objectPropertiesRepository = (ObjectPropertiesRepository)SpringContextUtil.getBean(ObjectPropertiesRepository.class);
    private DetailSyncRecordRepository detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
    private DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
    private BankVersionRepository bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);
    private DetailInfoService detailInfoService = DetailInfoService.getInstance();
    private List<QFilter> rowQFilter = new ArrayList<QFilter>(16);
    private Map<String, DynamicObject> currencyMap = new ConcurrentHashMap<String, DynamicObject>(5);

    public void setFilter(SetFilterEvent e) {
        ListShowParameter listShowParameter;
        String fromId;
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                if ("bank_version.id".equalsIgnoreCase(qFilter.getProperty()) || "bank_acnt.id".equalsIgnoreCase(qFilter.getProperty()) || "bank_currency.id".equalsIgnoreCase(qFilter.getProperty())) continue;
                this.rowQFilter.add(qFilter);
            }
        }
        if (Objects.equals(fromId = (String)(listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("fromId"), "receipt_stats_by_ac_day")) {
            String transDateStr = (String)listShowParameter.getCustomParam("transDateStr");
            Long accNoId = (Long)listShowParameter.getCustomParam("accNoId");
            Long currencyId = (Long)listShowParameter.getCustomParam("currencyId");
            String isInitFilter = this.getPageCache().get("isInitFilter");
            if (StringUtils.isEmpty((CharSequence)isInitFilter)) {
                if (accNoId != null) {
                    e.getQFilters().add(new QFilter("bank_acnt.id", "=", (Object)accNoId));
                }
                if (StringUtils.isNotEmpty((CharSequence)transDateStr)) {
                    e.getQFilters().add(new QFilter("trans_date", ">=", (Object)DateUtil.string2Date((String)transDateStr, (String)"yyyy-MM-dd")));
                }
                if (currencyId != null) {
                    e.getQFilters().add(new QFilter("bank_currency.id", ">=", (Object)currencyId));
                }
                this.getPageCache().put("isInitFilter", "true");
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String isInitFilter = this.getPageCache().get("isInitFilter");
        if (StringUtils.isEmpty((CharSequence)isInitFilter)) {
            String fromId;
            BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map paramMap = formShowParameter.getCustomParams();
            if (!CollectionUtils.isEmpty((Map)paramMap) && Objects.equals(fromId = (String)formShowParameter.getCustomParam("fromId"), "receipt_stats_by_ac_day")) {
                DynamicObject dynamicObject;
                String transDateStr = (String)formShowParameter.getCustomParam("transDateStr");
                Long accNoId = (Long)formShowParameter.getCustomParam("accNoId");
                Long currencyId = (Long)formShowParameter.getCustomParam("currencyId");
                String bankVersionName = "";
                if (accNoId != null && (dynamicObject = bankAcntRepository.findById(accNoId)) != null) {
                    bankVersionName = dynamicObject.getString("group.id");
                }
                this.getView().getPageCache().put("selectedBankId", bankVersionName);
                if (accNoId != null) {
                    this.getView().getPageCache().put("selectedAcntId", accNoId.toString());
                }
                if (currencyId != null) {
                    this.getView().getPageCache().put("bankCurrency", currencyId.toString());
                }
                for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    if (fieldName.equals("trans_date") && paramMap.get("transDateStr") != null) {
                        ArrayList<String> l = new ArrayList<String>(16);
                        l.add(transDateStr);
                        l.add(transDateStr);
                        commonFilterColumn.setDefaultValues(l);
                    }
                    if (fieldName.equals("bank_version.name") && StringUtils.isNotEmpty((CharSequence)bankVersionName)) {
                        commonFilterColumn.setDefaultValue(bankVersionName);
                    }
                    if (fieldName.equals("bank_acnt.number") && accNoId != null) {
                        commonFilterColumn.setDefaultValue(accNoId.toString());
                    }
                    if (!fieldName.equals("bank_currency.name") || accNoId == null) continue;
                    commonFilterColumn.setDefaultValue(currencyId.toString());
                }
            }
        }
        super.filterContainerInit(args);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String isKeyRepeat = String.valueOf(args.getFilterValue("is_key_repeat"));
        if ("null".equalsIgnoreCase(isKeyRepeat)) {
            isKeyRepeat = "";
        }
        this.getPageCache().put("isKeyRepeat", isKeyRepeat);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        DynamicObject dynamicObject;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String fromId = (String)listShowParameter.getCustomParam("fromId");
        String isInitQuery = this.getPageCache().get("isInitQuery");
        if (StringUtils.isEmpty((CharSequence)isInitQuery) && Objects.equals(fromId, "receipt_stats_by_ac_day")) {
            String transDateStrCache;
            DynamicObject dynamicObject2;
            BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
            Long accNoId = (Long)listShowParameter.getCustomParam("accNoId");
            Long currencyId = (Long)listShowParameter.getCustomParam("currencyId");
            String bankVersionName = "";
            if (accNoId != null && (dynamicObject2 = bankAcntRepository.findById(accNoId)) != null) {
                bankVersionName = dynamicObject2.getString("group.id");
            }
            this.getPageCache().put("selectedBankId", bankVersionName);
            if (accNoId != null) {
                this.getPageCache().put("selectedAcntId", accNoId.toString());
            }
            if (currencyId != null) {
                this.getPageCache().put("bankCurrency", currencyId.toString());
            }
            if (StringUtil.isNotNil(transDateStrCache = (String)listShowParameter.getCustomParam("transDateStr"))) {
                this.getPageCache().put("startDateTime", transDateStrCache + " 00:00:00");
                this.getPageCache().put("endDateTime", transDateStrCache + " 00:00:00");
            }
            this.getPageCache().put("isInitQuery", "true");
        }
        String bankVersionId = this.getPageCache().get("selectedBankId");
        String selectedAcntIdStr = this.getPageCache().get("selectedAcntId");
        String isKeyRepeatStr = this.getPageCache().get("isKeyRepeat");
        String bankCurrencyStr = this.getPageCache().get("bankCurrency");
        String startDateStr = this.getPageCache().get("startDateTime");
        String endDateStr = this.getPageCache().get("endDateTime");
        String acntNo = "";
        String currency = "";
        String bankVersionID = "";
        String bankName = "";
        if (StringUtils.isNotBlank((CharSequence)selectedAcntIdStr)) {
            DynamicObject acnt = this.bankAcntRepository.getAcntByID(Long.valueOf(selectedAcntIdStr));
            acntNo = acnt.getString("number");
            bankName = acnt.getString("group.bank_name");
        }
        if (StringUtils.isNotBlank((CharSequence)bankVersionId)) {
            DynamicObject bankVersion = this.bankVersionRepository.loadDynamicObjectByID(Long.valueOf(bankVersionId));
            bankVersionID = bankVersion.getString("number");
        }
        if (!StringUtil.isNullOrEmpty(bankCurrencyStr) && (dynamicObject = this.currencyRepository.findByID(Long.valueOf(Long.parseLong(bankCurrencyStr)))) != null) {
            currency = dynamicObject.getString("number");
        }
        final String currencyNumber = currency;
        final Integer isKeyRepeat = StringUtil.isNullOrEmpty(isKeyRepeatStr) ? null : Integer.valueOf(Integer.parseInt(isKeyRepeatStr));
        final LocalDate startDate = StringUtil.isNullOrEmpty(startDateStr) ? null : LocalDate.parse(startDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDate endDate = StringUtil.isNullOrEmpty(endDateStr) ? null : LocalDate.parse(endDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        final String sortInfo = ((BillList)this.getView().getControl("billlistap")).getEntryState().getSortInfo();
        final LocalDate finalEndDate = endDate;
        final String finalAcntNo = acntNo;
        final String finalBankVersionID = bankVersionID;
        final String finalBankName = bankName;
        final String customID = RequestContext.get().getTenantId();
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "page_data_data_count";
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int dataCount;
                ArrayList<Detail> details;
                int currentPage = start / limit + 1;
                int pageSize = limit;
                String source = iPageCache.get("source");
                boolean downloadFromBank = "downloadFromBank".equals(source);
                iPageCache.put("source", "");
                List rowFilters = BankAcntDetailListPlugin.this.rowQFilter;
                if (StringUtil.isNullOrEmpty(source)) {
                    details = new ArrayList(16);
                    Page detailInfoPage = BankAcntDetailListPlugin.this.detailInfoService.selectForPageAllowNull(customID, finalBankVersionID, finalAcntNo, currencyNumber, startDate, finalEndDate, isKeyRepeat, rowFilters, currentPage, pageSize, sortInfo);
                    List detailInfos = detailInfoPage.getContent();
                    if (!detailInfos.isEmpty()) {
                        for (DetailInfo info : detailInfos) {
                            details.add(DetailConvert.convert((DetailInfo)info));
                        }
                    }
                    dataCount = (int)detailInfoPage.getTotalElements();
                } else {
                    DetailResponseBody responseBody = BankAcntDetailListPlugin.this.getDetails(customID, finalAcntNo, startDate, finalEndDate, currencyNumber, isKeyRepeat, currentPage, pageSize, downloadFromBank);
                    details = responseBody.getDetails();
                    dataCount = responseBody.getTotalCount();
                }
                DynamicObjectCollection dObjectCollection = this.getCollection(details, finalBankName);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                iPageCache.put(dataCountCacheKey, dataCount + "");
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(List<Detail> details, String bankName) {
                String selectFields = "id, acc_no, acc_name, number, bank_name, trans_date, trans_time,detail_no, currencyfield,currency, debit_amount, credit_amount, sort_field, opp_acc_no, opp_acc_name, opp_bank_name, balance, explanation, unique_seq, bank_detail_no, is_key_repeat, match_node, receipt_no, createtime, modifytime";
                DynamicObjectCollection dCollection = new DynamicObjectCollection();
                if (CollectionUtil.isEmpty(details)) {
                    return QueryServiceHelper.query((String)BankAcntDetailListPlugin.ENTITY_KEY_BANK_ACNT_DETAIL, (String)selectFields, null);
                }
                details.stream().forEach(detail -> {
                    DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)BankAcntDetailListPlugin.ENTITY_KEY_BANK_ACNT_DETAIL);
                    data.set("id", (Object)(detail.getAccNo() + "_" + detail.getId()));
                    data.set("number", (Object)detail.getId());
                    data.set("acc_no", (Object)detail.getAccNo());
                    data.set("acc_name", (Object)detail.getAccName());
                    if (StringUtil.isNullOrEmpty(bankName)) {
                        data.set("bank_name", (Object)detail.getBankName());
                    } else {
                        data.set("bank_name", (Object)bankName);
                    }
                    if (BankAcntDetailListPlugin.this.currencyMap.get(detail.getCurrency()) == null) {
                        QFilter usd = QFilter.of((String)"number = ?", (Object[])new Object[]{detail.getCurrency()});
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (QFilter[])usd.toArray());
                        if (dynamicObject != null) {
                            BankAcntDetailListPlugin.this.currencyMap.put(detail.getCurrency(), dynamicObject);
                            data.set("currencyfield", (Object)dynamicObject);
                        }
                    } else {
                        data.set("currencyfield", BankAcntDetailListPlugin.this.currencyMap.get(detail.getCurrency()));
                    }
                    data.set("trans_date", (Object)DateUtil.string2Date((String)detail.getTransDate(), (String)"yyyyMMdd"));
                    data.set("trans_time", (Object)DateUtil.string2Date((String)detail.getDetailDateTime(), (String)"yyyyMMddHHmmss"));
                    data.set("detail_no", (Object)detail.getId());
                    data.set("unique_seq", (Object)detail.getUniqueSeq());
                    data.set("bank_detail_no", (Object)detail.getBankDetailNo());
                    data.set("is_key_repeat", (Object)detail.getIsKeyRepeat());
                    data.set("match_node", (Object)detail.getMatchNode());
                    data.set("currency", (Object)detail.getCurrency());
                    data.set("debit_amount", (Object)detail.getDebitAmount());
                    data.set("credit_amount", (Object)detail.getCreditAmount());
                    data.set("opp_acc_no", (Object)detail.getOppAccNo());
                    data.set("opp_acc_name", (Object)detail.getOppAccName());
                    data.set("opp_bank_name", (Object)detail.getOppBankName());
                    data.set("balance", (Object)detail.getBalance());
                    data.set("receipt_no", (Object)detail.getReceiptNo());
                    data.set("explanation", (Object)detail.getExplanation());
                    data.set("sort_field", (Object)detail.getSortField());
                    data.set("createtime", (Object)DateUtil.string2Date((String)detail.getInsertTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    data.set("modifytime", (Object)DateUtil.string2Date((String)detail.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    dCollection.add((Object)data);
                });
                return dCollection;
            }
        });
    }

    public DetailResponseBody getDetails(String customerID, String accNo, LocalDate startDate, LocalDate endDate, String currencyNumber, Integer isKeyRepeat, int currentPage, int pageSize, boolean downloadFromBank) {
        try {
            DetailResponse data = this.bizService.detail(customerID, accNo, startDate, endDate, currencyNumber, isKeyRepeat, currentPage, pageSize, downloadFromBank);
            return data.getBody();
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            DetailResponseBody result = new DetailResponseBody();
            result.setDetails(new ArrayList(1));
            result.setTotalCount(0);
            return result;
        }
    }

    boolean validDate(Date date) {
        Date monthLater = DateUtil.preMonth((Date)new Date(), (int)3);
        if (DateUtil.isBefore((Date)date, (Date)monthLater)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5141\u8bb8\u67e5\u8be23\u4e2a\u6708\u4e4b\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"BankAcntDetailListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"donothing", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"download_from_bank", (CharSequence)formOperate.getOperateKey())) {
            if (this.getPageCache().get("selectedAcntId") == null || "".equalsIgnoreCase(this.getPageCache().get("selectedAcntId"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u53f7\u3002", (String)"BankAcntDetailListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getPageCache().get("bankCurrency") == null || "".equalsIgnoreCase(this.getPageCache().get("bankCurrency"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"BankAcntDetailListPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getPageCache().get("startDateTime") == null || "".equalsIgnoreCase(this.getPageCache().get("startDateTime"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u6613\u65e5\u671f\u8303\u56f4\u3002", (String)"BankAcntDetailListPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            Date startDate = DateUtil.string2Date((String)this.getPageCache().get("startDateTime"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endDate = DateUtil.string2Date((String)this.getPageCache().get("endDateTime"), (String)"yyyy-MM-dd HH:mm:ss");
            if (!this.validDate(startDate)) {
                return;
            }
            if (DateUtil.getDayDiff((Date)startDate, (Date)endDate) > 30L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u5929\u3002", (String)"BankAcntDetailListPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            LocalDate today = LocalDate.now();
            if (this.isSearchFromFutureDate() && startDate != null && endDate != null) {
                LocalDate start = LocalDateUtils.date2LocalDate(startDate);
                LocalDate end = LocalDateUtils.date2LocalDate(endDate);
                if ((start.isBefore(today) || start.isEqual(today)) && end.isAfter(today)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u67e5\u8be2\u672a\u6765\u65e5\u671f\u548c\u5386\u53f2\uff08\u6216\u5f53\u65e5\uff09\u65e5\u671f\u3002", (String)"BankAcntDetailListPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)"donothing", (CharSequence)formOperate.getOperateKey())) {
                this.getPageCache().put("source", "search");
                this.getView().invokeOperation("refresh");
            } else {
                DynamicObject acnt = this.bankAcntRepository.getAcntByID(Long.valueOf(this.getPageCache().get("selectedAcntId")));
                String acntNo = acnt.getString("number");
                DynamicObject dynamicObject = this.currencyRepository.findByID(Long.valueOf(Long.parseLong(this.getPageCache().get("bankCurrency"))));
                String currency = dynamicObject.getString("number");
                String customID = RequestContext.get().getTenantId();
                LocalDate startLocalDate = LocalDateUtil.date2LocalDate((Date)startDate);
                LocalDate endLocalDate = LocalDateUtil.date2LocalDate((Date)endDate);
                int days = (int)(endLocalDate.toEpochDay() - startLocalDate.toEpochDay()) + 1;
                int maxNum = this.getSearchFromBankMaxNum();
                if (days == this.detailSyncRecordRepository.countByCustomIDAndAccNoAndSyncDateBetween(customID, acntNo, currency, startLocalDate, endLocalDate) && 0 == this.detailSyncRecordRepository.countByCustomIDAndAccNoAndSyncDateBetweenAndSyncCountLessThan(customID, acntNo, currency, startLocalDate, endLocalDate, maxNum)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u7684\u8054\u673a\u67e5\u8be2\u6b21\u6570\u5df2\u8fbe\u5230\u6700\u5927\u6b21\u6570%4$s\uff0c\u8bf7\u5230\u3010\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u3011\u9875\u9762->\u3010\u4ea4\u6613\u660e\u7ec6\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u7684\u6700\u5927\u6b21\u6570\u3011\u914d\u7f6e\u9879\u8c03\u5927\u6216\u8005\u4f7f\u7528\u666e\u901a\u67e5\u8be2\u64cd\u4f5c\u3002", (String)"BankAcntDetailListPlugin_13", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), acntNo, startLocalDate.toString(), endLocalDate.toString(), maxNum));
                    return;
                }
                this.getPageCache().put("source", "downloadFromBank");
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)"confirm_by_hand", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                args.setCancel(true);
                String detailId = selectedRow.getNumber();
                DynamicObject dynamicObject = this.detailInfoRepository.findById(Long.valueOf(detailId));
                if (dynamicObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"BankAcntDetailListPlugin_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    return;
                }
                int isKeyRepeat = dynamicObject.getInt("is_key_repeat");
                if (CosmicConstants.DETAIL_IS_KEY_REPEAT_N == isKeyRepeat) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u975e\u7591\u4f3c\u91cd\u590d\u3002", (String)"BankAcntDetailListPlugin_11", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    return;
                }
                dynamicObject.set("is_key_repeat", (Object)CosmicConstants.DETAIL_IS_KEY_REPEAT_N);
                dynamicObject.set("is_confirm", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BankAcntDetailListPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            });
        }
    }

    boolean isSearchFromFutureDate() {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("search_from_future_date", "ebg", "common_business");
        return objectProperties != null && !"false".equalsIgnoreCase(objectProperties.getAttrValue());
    }

    int getSearchFromBankMaxNum() {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("search_from_bank_max_num", "ebg", "common_business");
        if (objectProperties == null) {
            return BusinessPropertyConfig.getSearchFromBankMaxNumDefualtValue();
        }
        return Integer.parseInt(objectProperties.getAttrValue());
    }
}

