/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.index;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.model.constant.CertExpire;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class CertStatisticsPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"cert_name", (CharSequence)evt.getFieldName())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            customParams.put("cert_type", this.getPageCache().get("type_" + evt.getRowIndex()));
            customParams.put("certId", this.getPageCache().get("certId_" + evt.getRowIndex()));
            ShowPageUtil.showListPage("aqap_bd_cert", customParams, this.getView());
        }
    }

    public void beforeBindData(EventObject e) {
        this.loadData();
    }

    public void loadData() {
        String customID = RequestContext.get().getTenantId();
        QFilter[] filters = new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])};
        Date now = new Date();
        DynamicObject[] certs = BusinessDataServiceHelper.load((String)"aqap_bd_cert", (String)"id, type, cert_type, bank_config_name, file_name, expire_time", (QFilter[])filters, (String)"expire_time asc");
        int alertDays = 30;
        ArrayList<DynamicObject> expireList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> beexpireList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> otherList = new ArrayList<DynamicObject>(16);
        Date next30Date = DateUtil.getNextDay((Date)now, (int)alertDays);
        if (certs.length > 0) {
            for (int i = 0; i < certs.length; ++i) {
                Date expireTime = certs[i].getDate("expire_time");
                if (expireTime == null) {
                    otherList.add(certs[i]);
                    continue;
                }
                if (!DateUtil.isBefore((Date)now, (Date)expireTime)) {
                    expireList.add(certs[i]);
                    continue;
                }
                if (!DateUtil.isBefore((Date)next30Date, (Date)expireTime)) {
                    beexpireList.add(certs[i]);
                    continue;
                }
                otherList.add(certs[i]);
            }
        }
        Label label = (Label)this.getControl("cert_count");
        int cert_count = certs.length;
        label.setText(cert_count + "");
        this.buildEntryRow(expireList, CertExpire.HAVE_EXPIRE.getType());
        Label label1 = (Label)this.getControl("expire_count");
        label1.setText(expireList.size() + "");
        this.buildEntryRow(beexpireList, CertExpire.WILL_EXPIRE.getType());
        Label label2 = (Label)this.getControl("beexpire_count");
        label2.setText(beexpireList.size() + "");
        this.buildEntryRow(otherList, CertExpire.NOT_EXPIRE.getType());
        Label label3 = (Label)this.getControl("other_count");
        label3.setText(otherList.size() + "");
        this.setColor(expireList.size(), beexpireList.size(), otherList.size());
    }

    public void buildEntryRow(List<DynamicObject> dynamicObjects, String type) {
        if (CollectionUtil.isNotEmpty(dynamicObjects)) {
            Date now = new Date();
            for (DynamicObject dynamicObject : dynamicObjects) {
                int row = this.getModel().createNewEntryRow("entryentity");
                int certType = dynamicObject.getInt("cert_type");
                String bank_config_name = dynamicObject.getString("bank_config_name");
                String certId = dynamicObject.getString("id");
                Date expireTime = dynamicObject.getDate("expire_time");
                String typeName = CertExpire.getNameByType((String)type);
                if (CertExpire.WILL_EXPIRE.getType().equalsIgnoreCase(type)) {
                    long day = DateUtil.getDayDiff((Date)now, (Date)expireTime);
                    typeName = String.format(ResManager.loadKDString((String)"%1$s\u5929\u540e\u8fc7\u671f\u3002", (String)"CertStatisticsPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), day);
                }
                String expireTimeStr = DateUtil.formatDate((Date)expireTime, (String)"yyyy-MM-dd");
                DynamicObject dynamicObject2 = this.getModel().getEntryRowEntity("entryentity", row);
                dynamicObject2.set("type", (Object)typeName);
                dynamicObject2.set("cert_type", (Object)CertTypeEnum.getNameByType((Integer)certType));
                dynamicObject2.set("cert_name", (Object)bank_config_name);
                dynamicObject2.set("expire_time", (Object)expireTimeStr);
                this.getPageCache().put("type_" + row, certType + "");
                this.getPageCache().put("certId_" + row, certId);
            }
        }
    }

    public void setColor(int expireCount, int beexpireCount, int otherCount) {
        int count = expireCount + beexpireCount + otherCount;
        for (int i = 0; i < count; ++i) {
            String color = i < expireCount ? "#FB2323" : (i < expireCount + beexpireCount ? "#FF991C" : "#1BA854");
            this.setColor(i, color);
        }
    }

    public void setColor(int row, String color) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setForeColor(color);
        cs.setFieldKey("type");
        cs.setRow(row);
        csList.add(cs);
        grid.setCellStyle(csList);
    }
}

