/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.license;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.license.EbgLicenseModuleEnum;
import kd.ebg.egf.common.license.LicenseCache;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.repository.license.LicenseFileRepository;

public class LicenseInfoPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"refresh"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals("open_old_license", formOperate.getOperateKey())) {
            this.showListPage("aqap_old_license_page", null);
        }
    }

    public void afterBindData(EventObject e) {
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modeType = service.getModeType();
        if (modeType > 3) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"open_old_license"});
        }
    }

    public void showListPage(String formId, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        if (!CollectionUtils.isEmpty(customParams)) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        LicenseFile licenseFile = this.findLinceseByCustom();
        if ("refresh".equals(key)) {
            if (licenseFile != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u5df2\u5bfc\u5165\u94f6\u4f01\u4e914.0\u7684\u8bb8\u53ef\u6587\u4ef6\uff0c\u8bf7\u5230\u94f6\u4f01\u4e914.0\u8bb8\u53ef\u4fe1\u606f\u83dc\u5355\u67e5\u770b\u8bb8\u53ef\u3002", (String)"LicenseInfoPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"aqap_license_detail").getDynamicObjectType();
            BusinessDataServiceHelper.removeCache((DynamicObjectType)dynamicObjectType);
            DynamicObjectType licenseFileDynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"aqap_license_file").getDynamicObjectType();
            BusinessDataServiceHelper.removeCache((DynamicObjectType)licenseFileDynamicObjectType);
            this.getView().invokeOperation("refresh");
        }
    }

    private LicenseFile findLinceseByCustom() {
        LicenseFileRepository licenseFileRepository = (LicenseFileRepository)SpringContextUtil.getBean(LicenseFileRepository.class);
        return licenseFileRepository.findByCustomId(RequestContext.get().getTenantId());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showLicenseList();
    }

    private void showLicenseList() {
        LicenseFile licenseFile = this.findLinceseByCustom();
        if (licenseFile != null) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        TenantInfo tenantLicenseInfo = LicenseCache.getTenant();
        TenantInfo tenantForNote = LicenseCache.getTenantForNote();
        this.showBaseInfo(tenantLicenseInfo, tenantForNote);
        ArrayList tempLists = Lists.newArrayList();
        List licenseDetails = tenantLicenseInfo.getInfos();
        tempLists.addAll(licenseDetails);
        tempLists.addAll(tenantForNote.getInfos());
        Map<String, List<LicenseDetail>> map = tempLists.stream().collect(Collectors.groupingBy(LicenseDetail::getModuleCode));
        List<EbgLicenseModuleEnum> ebgLicenseModuleEnums = Arrays.asList(EbgLicenseModuleEnum.values());
        List<EbgLicenseModuleEnum> sortList = ebgLicenseModuleEnums.stream().sorted(Comparator.comparing(EbgLicenseModuleEnum::getSort)).collect(Collectors.toList());
        sortList.forEach(ebgLicenseModuleEnum -> {
            String moduleCode = ebgLicenseModuleEnum.getModuleCode();
            List lists = (List)map.get(moduleCode);
            DynamicObject row = entries.addNew();
            this.setEntryValues((EbgLicenseModuleEnum)ebgLicenseModuleEnum, row, lists);
            if (EbgLicenseModuleEnum.NOTE.getModuleCode().equalsIgnoreCase(moduleCode)) {
                row.set("module_expired_date", (Object)(StringUtils.isNotEmpty(tenantForNote.getExpiredDate()) ? tenantForNote.getExpiredDate().substring(0, 10) : tenantForNote.getExpiredDate()));
            } else {
                row.set("module_expired_date", (Object)(StringUtils.isNotEmpty(tenantLicenseInfo.getExpiredDate()) ? tenantLicenseInfo.getExpiredDate().substring(0, 10) : tenantLicenseInfo.getExpiredDate()));
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            grid.setRowBackcolor("#eff3fd", new int[]{0});
        });
        this.judgeLicenseCount(tenantLicenseInfo, tenantForNote);
    }

    private void setEntryValues(EbgLicenseModuleEnum licenseModuleEnum, DynamicObject row, List<LicenseDetail> licenseDetailList) {
        String moduleCode = licenseModuleEnum.getModuleCode();
        String moduleName = licenseModuleEnum.getModuleName();
        row.set("license_module_name", (Object)moduleName);
        row.set("license_module_code", (Object)moduleCode);
        row.set("used_license_count", (Object)(licenseDetailList != null ? licenseDetailList.size() : 0));
        String businessScope = EbgLicenseModuleEnum.getBusinessScopeWithModuleCode((String)moduleCode);
        row.set("business_scope", (Object)businessScope);
        if (EbgLicenseModuleEnum.PAY.getModuleCode().equalsIgnoreCase(moduleCode)) {
            row.set("module_group_code", (Object)"PRO_AQAP");
            row.set("module_group_name", (Object)ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"LicenseInfoPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            row.set("license_count", (Object)LicenseCache.getTenant().getTotalLicenseCount());
            row.set("module_unused_count", (Object)LicenseCache.getTenant().getUnusedLicenseCount());
        } else if (EbgLicenseModuleEnum.NOTE.getModuleCode().equalsIgnoreCase(moduleCode)) {
            row.set("module_group_code", (Object)"PRO_NOTE");
            row.set("module_group_name", (Object)ResManager.loadKDString((String)"\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3", (String)"LicenseInfoPlugin_13", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            row.set("license_count", (Object)LicenseCache.getTenantForNote().getTotalLicenseCount());
            row.set("module_unused_count", (Object)LicenseCache.getTenantForNote().getUnusedLicenseCount());
        } else {
            row.set("module_group_code", (Object)"");
            row.set("module_group_name", (Object)"");
        }
    }

    private void showBaseInfo(TenantInfo tenantInfo, TenantInfo tenantInfoForNote) {
        this.getModel().setValue("group_number", (Object)tenantInfo.getGroupNumber());
        this.getModel().setValue("group_name", (Object)tenantInfo.getGroupName());
        this.getModel().setValue("price_mode", (Object)tenantInfo.getCalcType());
        this.getModel().setValue("file_type", (Object)tenantInfo.getFileType());
        this.getModel().setValue("domain", (Object)tenantInfo.getRegion());
        this.getModel().setValue("total_count", (Object)(tenantInfo.getTotalLicenseCount() + tenantInfoForNote.getTotalLicenseCount()));
        this.getModel().setValue("used_count", (Object)(tenantInfo.getUsedLicenseCount() + tenantInfoForNote.getUsedLicenseCount()));
        this.getModel().setValue("unused_count", (Object)(tenantInfo.getUnusedLicenseCount() + tenantInfoForNote.getUnusedLicenseCount()));
        this.getModel().setValue("license_version", (Object)tenantInfo.getLicenseVersion());
        this.judgeLicense(tenantInfo.getDeadline());
    }

    public void judgeLicenseCount(TenantInfo tenantLicenseInfo, TenantInfo tenantForNote) {
        int unusedLicenseCount = tenantLicenseInfo.getUnusedLicenseCount();
        int unusedLicenseCountNote = tenantForNote.getUnusedLicenseCount();
        StringBuilder stringBuilder = new StringBuilder();
        if (unusedLicenseCount < 0 && unusedLicenseCountNote < 0) {
            stringBuilder.append(ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u548c\u94f6\u4f01\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u7684\u8bb8\u53ef\u5206\u7ec4\u6570\u91cf\u5c0f\u4e8e\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u5df2\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u6a21\u5757\u76f8\u5173\u4e1a\u52a1\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u8db3\u591f\u8bb8\u53ef\u6570\u91cf\u3002", (String)"LicenseInfoPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (unusedLicenseCount < 0) {
            stringBuilder.append(ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u7684\u8bb8\u53ef\u5206\u7ec4\u6570\u91cf\u5c0f\u4e8e\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u5df2\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u6a21\u5757\u76f8\u5173\u4e1a\u52a1\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u8db3\u591f\u8bb8\u53ef\u6570\u91cf\u3002", (String)"LicenseInfoPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        } else if (unusedLicenseCountNote < 0) {
            stringBuilder.append(ResManager.loadKDString((String)"\u94f6\u4f01\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u7684\u8bb8\u53ef\u5206\u7ec4\u6570\u91cf\u5c0f\u4e8e\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u5df2\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u6a21\u5757\u76f8\u5173\u4e1a\u52a1\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u8db3\u591f\u8bb8\u53ef\u6570\u91cf\u3002", (String)"LicenseInfoPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty(stringBuilder.toString())) {
            this.getView().showErrorNotification(stringBuilder.toString());
        }
    }

    public void judgeLicense(LocalDateTime expiredDate) {
        LocalDate now = LocalDate.now();
        long daysBetween = expiredDate.toLocalDate().toEpochDay() - now.toEpochDay();
        if (daysBetween <= 30L) {
            if (daysBetween >= 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8bb8\u53ef\u8fd8\u6709%s\u5929\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u7eed\u8d39\u3002", (String)"LicenseInfoPlugin_11", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), daysBetween));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u8bb8\u53ef\u5df2\u5230\u671f\uff0c\u5df2\u4e0d\u80fd\u4f7f\u7528\u94f6\u4f01\u4e91\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u3002", (String)"LicenseInfoPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("used_license_count".equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            String licenseModuleCode = ((DynamicObject)collection.get(evt.getRowIndex())).getString("license_module_code");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("licenseModuleCode", licenseModuleCode);
            FormShowParameter showParameter = LicenseInfoPlugin.getFormShowParameter(this, "aqap_license_detail_page", ResManager.loadKDString((String)"\u8bb8\u53ef\u4f7f\u7528\u8be6\u60c5", (String)"LicenseInfoPlugin_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), params, null);
            StyleCss style = new StyleCss();
            style.setWidth("800");
            style.setHeight("600");
            showParameter.getOpenStyle().setInlineStyleCss(style);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private static FormShowParameter getFormShowParameter(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        return p;
    }
}

