/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillPlugin;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.zip.io.outputstream.ZipOutputStream;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.EncryptionMethod;
import kd.ebg.aqap.formplugin.esclient.LogInfo;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.framework.frame.BusinessTypeUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class DownLoadLogPlugin
extends EbcAddBankListPlugin
implements IBillPlugin {
    EBGLogger log = EBGLogger.getInstance().getLogger(DownLoadLogPlugin.class);
    private String ENTITY_NAME_LIST = "aqap_new_log";
    private String SELECT_ALL_PROPERTIES_LIST = "id,biz_name,account,bank_version,bank_login,logger_batch_no,logger_detail_no,dt_query,logger_bank_no,logger_type,biz_seq";
    static final String EB = "eb_bankNewLogDetailPlugin_";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals("donothing", formOperate.getOperateKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("aqap_log_download_confirm");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String logger_bank_no = this.getPageCache().get("eb_bankNewLogDetailPlugin_logger_bank_no");
            String logger_batch_no = this.getPageCache().get("eb_bankNewLogDetailPlugin_logger_batch_no");
            String logger_detail_no = this.getPageCache().get("eb_bankNewLogDetailPlugin_logger_detail_no");
            String biz_name = this.getPageCache().get("eb_bankNewLogDetailPlugin_biz_name");
            String account = this.getPageCache().get("eb_bankNewLogDetailPlugin_account");
            String bank_version = this.getPageCache().get("eb_bankNewLogDetailPlugin_bank_version");
            String log_time = this.getPageCache().get("eb_bankNewLogDetailPlugin_log_time");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("logger_bank_no", logger_bank_no);
            map.put("logger_batch_no", logger_batch_no);
            map.put("logger_detail_no", logger_detail_no);
            map.put("biz_name", biz_name);
            map.put("account", account);
            map.put("bank_version", bank_version);
            map.put("log_time", log_time);
            showParameter.setCustomParams(map);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals("download_log_confirm", formOperate.getOperateKey())) {
            String ciper = (String)this.getModel().getValue("log_ciper");
            if (StringUtils.isEmpty(ciper)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65e5\u5fd7\u538b\u7f29\u5305\u52a0\u5bc6\u5bc6\u7801\u3002", (String)"DownLoadLogPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            try {
                byte[] bytes;
                String content = ResManager.loadKDString((String)"\u6d4b\u8bd5\u4e0b\u8f7d", (String)"DownLoadLogPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
                TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
                Map<String, byte[]> map = this.getFiles();
                byte[] bin = this.zipFiles(map);
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                     ZipOutputStream out = new ZipOutputStream((OutputStream)bos, ciper.toCharArray(), StandardCharsets.UTF_8);){
                    ZipParameters zipParameters = new ZipParameters();
                    zipParameters.setFileNameInZip("log.zip");
                    zipParameters.setFileComment(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u65e5\u5fd7\u6253\u5305", (String)"DownLoadLogPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    zipParameters.setEncryptFiles(true);
                    zipParameters.setEncryptionMethod(EncryptionMethod.AES);
                    out.putNextEntry(zipParameters);
                    out.write(bin);
                    out.closeEntry();
                    out.flush();
                    out.close();
                    bytes = bos.toByteArray();
                    bos.close();
                }
                String url = tfc.saveAsUrl(this.getZipName(), bytes, 120);
                this.getView().download(url);
                this.getView().invokeOperation("close");
            }
            catch (Exception e) {
                this.log.info("\u538b\u7f29\u65e5\u5fd7\u5f02\u5e38" + e.getMessage());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u538b\u7f29\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DownLoadLogPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.getView().invokeOperation("close");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private byte[] zipFiles(Map<String, byte[]> jarMap) {
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                Throwable throwable2;
                ZipOutputStream out;
                block31: {
                    block32: {
                        out = new ZipOutputStream((OutputStream)bos);
                        throwable2 = null;
                        for (Map.Entry<String, byte[]> jar : jarMap.entrySet()) {
                            ZipParameters zipParameters = new ZipParameters();
                            zipParameters.setFileNameInZip(jar.getKey());
                            zipParameters.setFileComment(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u65e5\u5fd7\u6253\u5305", (String)"DownLoadLogPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                            out.putNextEntry(zipParameters);
                            out.write(jar.getValue());
                            out.closeEntry();
                            out.flush();
                        }
                        out.close();
                        byte[] bytes = bos.toByteArray();
                        bos.close();
                        byArray = bytes;
                        if (out == null) break block31;
                        if (throwable2 == null) break block32;
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block31;
                    }
                    out.close();
                }
                return byArray;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (out != null) {
                                    if (throwable2 != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        out.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (IOException e) {
                            this.log.error("exception:", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.error("exception:", (Throwable)e);
        }
        return null;
    }

    private Map<String, byte[]> getFiles() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String logger_bank_no = (String)params.get("logger_bank_no");
        String logger_batch_no = (String)params.get("logger_batch_no");
        String logger_detail_no = (String)params.get("logger_detail_no");
        String biz_name = (String)params.get("biz_name");
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        List<LogInfo> logInfos = null;
        Object logInfosEach = null;
        if ("pay".equals(biz_name) || "overseaPay".equals(biz_name) || "linkpay".equalsIgnoreCase(biz_name) || "notePayable".equals(biz_name) || "noteReceivable".equals(biz_name) || "currentAndFixed".equals(biz_name) || "queryCurrentAndFixed".equals(biz_name) || "withdrawFromNAcc".equals(biz_name) || "buyFinancing".equals(biz_name) || "queryBuyFinancing".equals(biz_name) || "redeemFinancing".equals(biz_name) || "queryRedeemFinancing".equals(biz_name)) {
            logInfos = BusinessTypeUtil.INSTANCE.isSynBusiness(biz_name) ? this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_request", biz_name) : this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_request", null);
            String bussiness_request = this.formatViewSimple(logInfos);
            map.put(this.getFileName(biz_name, "request"), bussiness_request.getBytes(StandardCharsets.UTF_8));
            logInfos = BusinessTypeUtil.INSTANCE.isSynBusiness(biz_name) ? this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", biz_name) : this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", null);
            String bussiness_response = this.formatViewSimple(logInfos);
            map.put(this.getFileName(biz_name, "response"), bussiness_response.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_bank", null);
            String bank_log = this.formatView(logInfos);
            map.put(this.getFileName(biz_name, "bank"), bank_log.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_process", null);
            String other_log = this.formatView(logInfos);
            map.put(this.getFileName(biz_name, "other"), other_log.getBytes(StandardCharsets.UTF_8));
        } else if ("queryLinkpay".equalsIgnoreCase(biz_name) || "queryPay".equals(biz_name) || "queryOverseaPay".equals(biz_name) || "queryNotePayable".equals(biz_name) || "queryNoteReceivable".equals(biz_name)) {
            logInfos = BusinessTypeUtil.INSTANCE.isSynBusiness(biz_name) ? this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_request", biz_name) : this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_request", null);
            String bussiness_request = this.formatViewSimple(logInfos);
            map.put(this.getFileName(biz_name, "request"), bussiness_request.getBytes(StandardCharsets.UTF_8));
            logInfos = BusinessTypeUtil.INSTANCE.isSynBusiness(biz_name) ? this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", biz_name) : this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", null);
            String bussiness_response = this.formatViewSimple(logInfos);
            map.put(this.getFileName(biz_name, "response"), bussiness_response.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_bank", null);
            String bank_log = this.formatView(logInfos);
            map.put(this.getFileName(biz_name, "bank"), bank_log.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_process", null);
            String other_log = this.formatView(logInfos);
            map.put(this.getFileName(biz_name, "other"), other_log.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, null, "bussiness_request", DownLoadLogPlugin.getBussiness(biz_name));
            String bussiness_request_pay = this.formatView(logInfos);
            map.put(this.getFileName(DownLoadLogPlugin.getBussiness(biz_name), "request"), bussiness_request_pay.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, null, "bussiness_response", DownLoadLogPlugin.getBussiness(biz_name));
            String bussiness_response_pay = this.formatView(logInfos);
            map.put(this.getFileName(DownLoadLogPlugin.getBussiness(biz_name), "response"), bussiness_response_pay.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, logger_detail_no, null, "bussiness_bank", DownLoadLogPlugin.getBussiness(biz_name));
            String bank_log_pay = this.formatView(logInfos);
            map.put(this.getFileName(DownLoadLogPlugin.getBussiness(biz_name), "bank"), bank_log_pay.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, null, "bussiness_process", DownLoadLogPlugin.getBussiness(biz_name));
            String other_log_pay = this.formatView(logInfos);
            map.put(this.getFileName(DownLoadLogPlugin.getBussiness(biz_name), "other"), other_log_pay.getBytes(StandardCharsets.UTF_8));
        } else {
            logInfos = this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_request", null);
            String bussiness_request = this.formatViewSimple(logInfos);
            map.put("request.txt", bussiness_request.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_response", null);
            String bussiness_response = this.formatViewSimple(logInfos);
            map.put("response.txt", bussiness_response.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, logger_detail_no, logger_bank_no, "bussiness_bank", null);
            String bank_log = this.formatView(logInfos);
            map.put("bank.txt", bank_log.getBytes(StandardCharsets.UTF_8));
            logInfos = this.getBizLog(logger_batch_no, null, logger_bank_no, "bussiness_process", null);
            String other_log = this.formatView(logInfos);
            map.put("other.txt", other_log.getBytes(StandardCharsets.UTF_8));
        }
        return map;
    }

    public List<LogInfo> getBizLog(String logger_batch_no, String logger_detail_no, String logger_bank_no, String bussiness_type, String bizName) {
        QFilter filter1;
        LogORM logORM = LogORM.create();
        ArrayList<QFilter> list = new ArrayList<QFilter>(1);
        QFilter filter = QFilter.of((String)"logger_batch_no = ?", (Object[])new Object[]{logger_batch_no});
        list.add(filter);
        if (StringUtils.isNotEmpty(logger_detail_no)) {
            filter1 = QFilter.of((String)"logger_detail_no = ?", (Object[])new Object[]{logger_detail_no});
            list.add(filter1);
        }
        if (StringUtils.isNotEmpty(logger_bank_no)) {
            filter1 = QFilter.of((String)"logger_bank_no = ?", (Object[])new Object[]{logger_bank_no});
            list.add(filter1);
        }
        if (StringUtils.isNotEmpty(bussiness_type)) {
            filter1 = QFilter.of((String)"logger_type = ?", (Object[])new Object[]{bussiness_type});
            list.add(filter1);
        }
        if (StringUtils.isNotEmpty(bizName)) {
            filter1 = QFilter.of((String)"biz_name = ?", (Object[])new Object[]{bizName});
            list.add(filter1);
        }
        list.toArray(new QFilter[list.size()]);
        DataSet ds = logORM.queryDataSet("aqap_biz_log", "log_content_tag,dt_query,biz_seq", list.toArray(new QFilter[list.size()]), 10000, 0).orderBy(new String[]{"biz_seq asc", "dt_query asc"});
        ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>(1);
        while (ds.hasNext()) {
            Row row = ds.next();
            LogInfo info = new LogInfo();
            info.setMessage(row.get(0).toString());
            logInfoList.add(info);
        }
        return logInfoList;
    }

    public List<LogInfo> getBizLogIndex(String logger_batch_no) {
        QFilter filter = QFilter.of((String)"logger_batch_no=?", (Object[])new Object[]{logger_batch_no});
        DynamicObject[] dynamicObjecst = BusinessDataServiceHelper.load((String)this.ENTITY_NAME_LIST, (String)this.SELECT_ALL_PROPERTIES_LIST, (QFilter[])filter.toArray());
        ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>(1);
        for (DynamicObject dynamicObject : dynamicObjecst) {
            LogInfo info = new LogInfo();
            info.setLogger_batch_no(logger_batch_no);
            info.setLogger_bank_no(dynamicObject.getString("logger_bank_no"));
            info.setLogger_detail_no(dynamicObject.getString("logger_detail_no"));
            info.setBizName(dynamicObject.getString("biz_name"));
            info.setBussiness_type(dynamicObject.getString("logger_type"));
            info.setEsId(dynamicObject.getString("dt_query"));
            logInfoList.add(info);
        }
        return logInfoList;
    }

    private String formatViewSimple(List<LogInfo> logInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        if (logInfos != null) {
            for (LogInfo info : logInfos) {
                if (!StringUtils.isNotEmpty(info.getMessage())) continue;
                stringBuilder.append(this.transFormat(info.getMessage()));
                stringBuilder.append("\r\n");
            }
            if (StringUtils.isEmpty(stringBuilder.toString())) {
                return ResManager.loadKDString((String)"\u65e0\u6570\u636e\uff0c\u53ef\u80fd\u662f\u94f6\u4f01\u4e91\u9875\u9762\u64cd\u4f5c\u6216\u8005\u94f6\u4f01\u4e91\u540e\u53f0\u8c03\u5ea6\u3002", (String)"DownLoadLogPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            }
            return stringBuilder.toString();
        }
        return ResManager.loadKDString((String)"\u65e0\u6570\u636e\uff0c\u53ef\u80fd\u662f\u94f6\u4f01\u4e91\u9875\u9762\u64cd\u4f5c\u6216\u8005\u94f6\u4f01\u4e91\u540e\u53f0\u8c03\u5ea6\u3002", (String)"DownLoadLogPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
    }

    private String transFormat(String str) {
        if (StringUtil.isNil(str)) {
            return "-";
        }
        return str;
    }

    private String formatView(List<LogInfo> logInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        if (logInfos != null) {
            for (LogInfo info : logInfos) {
                if (!StringUtils.isNotEmpty(info.getMessage())) continue;
                stringBuilder.append(this.transFormat(info.getMessage()));
                stringBuilder.append("\r\n");
            }
            if (StringUtils.isEmpty(stringBuilder.toString())) {
                return MultiLang.getDataEmptyTip();
            }
            return stringBuilder.toString();
        }
        return MultiLang.getDataEmptyTip();
    }

    private String getZipName() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String logger_bank_no = (String)params.get("logger_bank_no");
        String logger_batch_no = (String)params.get("logger_batch_no");
        String logger_detail_no = (String)params.get("logger_detail_no");
        String biz_name = (String)params.get("biz_name");
        String account = (String)params.get("account");
        String bank_version = (String)params.get("bank_version");
        String log_time = (String)params.get("log_time");
        StringBuilder builder = new StringBuilder();
        builder.append(biz_name).append("_");
        builder.append(account).append("_");
        builder.append(bank_version).append("_");
        builder.append(log_time).append("_");
        builder.append(logger_batch_no).append(".zip");
        return builder.toString();
    }

    private String getFileName(LogInfo info, String fix) {
        StringBuilder builder = new StringBuilder();
        builder.append(info.getBizName()).append("_");
        builder.append(fix).append("_");
        builder.append(info.getLogger_bank_no()).append("_");
        builder.append(info.getEsId());
        builder.append(".txt");
        return builder.toString();
    }

    private String getFileName(String bizName, String fix) {
        StringBuilder builder = new StringBuilder();
        builder.append(bizName).append("_");
        builder.append(fix);
        builder.append(".txt");
        return builder.toString();
    }

    public static String getBussiness(String bizName) {
        return BusinessTypeUtil.INSTANCE.getBusinessType(bizName);
    }
}

