/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class LocalDateUtils {
    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate getDayAfter(LocalDate localDate, int day) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zdt.toInstant());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, day);
        date = c.getTime();
        Instant instant = date.toInstant();
        localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

