/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jlb.cms.services.payment.company;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jlb.cms.services.Common;
import kd.ebg.aqap.banks.jlb.cms.services.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryCompanyPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "200205";
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"req_no", (String)paymentInfo.getBankDetailSeqId());
        String d = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)d);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List infos = bankPayRequest.getPaymentInfos();
        if (infos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u7b14\u5bf9\u5916\u8f6c\u8d26\u67e5\u8bc1\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf", (String)"QryCompanyPaymentImpl_0", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryCompanyPaymentImpl_1", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(infos);
        }
        Element body = ap.getChild("body");
        String stat = body.getChildTextTrim("stat");
        String error_info = body.getChildTextTrim("error_info");
        if ("9".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryCompanyPaymentImpl_2", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryCompanyPaymentImpl_2", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]));
        } else if ("6".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryCompanyPaymentImpl_3", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)stat, (String)error_info);
        } else if ("3".equals(stat) || "4".equals(stat) || "5".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QryCompanyPaymentImpl_4", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)stat, (String)error_info);
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryCompanyPaymentImpl_1", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), (String)stat, (String)error_info);
        }
        return new EBBankPayResponse(infos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8f6c\u8d26\u4ea4\u6613\u6d41\u6c34\u72b6\u6001 (200205\u4ea4\u6613)", (String)"QryCompanyPaymentImpl_5", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);
    }
}

